/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.visualization.gui.msaa.properties.IPropertyInvoke;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.MethodData;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.MethodInvokeDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractPropertyInvokeSource
implements IPropertyInvoke {
    private Map<Object, MethodData> methodMap = new HashMap<Object, MethodData>();

    protected void addMethodData(Object id, MethodData methodData) {
        this.methodMap.put(id, methodData);
    }

    private MethodData getMethodData(Object id) {
        MethodData data = this.methodMap.get(id);
        if (data instanceof MethodData) {
            return data;
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptorsExtra() {
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        MethodData methodData = this.getMethodData(id);
        if (methodData != null) {
            return methodData.getResult();
        }
        return null;
    }

    public final boolean canInvoke(Object id) {
        MethodData methodData = this.getMethodData(id);
        if (methodData != null) {
            return methodData.canInvole();
        }
        return false;
    }

    public final boolean invoke(Object id, Shell shell) {
        MethodData methodData = this.getMethodData(id);
        if (methodData != null && methodData.canInvole()) {
            MethodInvokeDialog dialog;
            if (methodData.getTitle() != null && (dialog = new MethodInvokeDialog(shell, methodData)).open() != 0) {
                return false;
            }
            methodData.invoke();
            return true;
        }
        return false;
    }
}

