/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import java.util.ArrayList;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.as.ASDeserializer;
import org.eclipse.actf.model.flash.as.ASObject;
import org.eclipse.actf.model.flash.as.ASSerializer;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.actf.model.internal.flash.ASNodeImplV8;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.swt.widgets.Display;

public class ASBridgeImplV8
implements IASBridge {
    private IFlashPlayer flashPlayer;
    private IDispatch idispFlash;
    private Object objMarker;
    private String requestArgsPath;
    private String responseValuePath;
    private String contentIdPath;
    private String secret = null;
    private boolean _isRepaired = false;

    public ASBridgeImplV8(IFlashPlayer flashPlayer) {
        this.flashPlayer = flashPlayer;
        this.idispFlash = flashPlayer.getDispatch();
        String rootPath = "";
        if ("true".equals(this.getVariable("_level0.Eclipse_ACTF_is_available"))) {
            rootPath = "_level0";
        } else if ("true".equals(this.getVariable("_level53553.Eclipse_ACTF_is_available"))) {
            rootPath = "_level53553";
        }
        this.requestArgsPath = String.valueOf(rootPath) + ".Eclipse_ACTF_request_args";
        this.responseValuePath = String.valueOf(rootPath) + ".Eclipse_ACTF_response_value";
        this.contentIdPath = String.valueOf(rootPath) + ".Eclipse_ACTF_SWF_CONTENT_ID";
    }

    private String getVariable(String name) {
        try {
            Object obj = this.idispFlash.invoke1("GetVariable", (Object)name);
            return (String)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setVariable(String name, String value) {
        try {
            this.idispFlash.invoke("SetVariable", new Object[]{name, value});
        }
        catch (Exception exception) {}
    }

    private boolean initSecret() {
        String id;
        block4: {
            if (this.secret != null) {
                return true;
            }
            id = this.getVariable(this.contentIdPath);
            if (id != null && id.length() != 0) break block4;
            return false;
        }
        try {
            IWaXcoding waxcoding = WaXcodingFactory.getWaXcoding();
            this.secret = waxcoding.getSecret(id, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.secret != null;
    }

    private Object invoke(String method) {
        return this.invoke(new Object[]{method});
    }

    private Object invoke(String method, Object arg1) {
        return this.invoke(new Object[]{method, arg1});
    }

    private Object invoke(Object[] args) {
        block5: {
            if (this.initSecret()) break block5;
            return null;
        }
        try {
            this.setVariable(this.responseValuePath, "");
            String argsStr = ASSerializer.serialize(this.secret, args);
            this.setVariable(this.requestArgsPath, argsStr);
            long endTime = System.currentTimeMillis() + 100L;
            while (endTime > System.currentTimeMillis()) {
                String value = this.getVariable(this.responseValuePath);
                if (value != null && value.length() > 0) {
                    ASDeserializer asd = new ASDeserializer(value);
                    return asd.deserialize();
                }
                Display.getCurrent().readAndDispatch();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private IASNode[] createFlashNodeArray(Object object, IASNode parentNode) {
        ArrayList<ASNodeImplV8> children = new ArrayList<ASNodeImplV8>();
        if (object instanceof Object[]) {
            Object[] objChildren = (Object[])object;
            int i = 0;
            while (i < objChildren.length) {
                if (objChildren[i] instanceof ASObject) {
                    children.add(new ASNodeImplV8(parentNode, this.flashPlayer, (ASObject)objChildren[i]));
                }
                ++i;
            }
        }
        return children.toArray(new ASNodeImplV8[children.size()]);
    }

    private void initMarker() {
        if (this.objMarker != null) {
            return;
        }
        Object result = this.invoke("newMarker");
        if (result instanceof Integer) {
            this.objMarker = result;
            return;
        }
        this.objMarker = null;
    }

    public Object callMethod(IASNode targetNode, String method) {
        return this.invoke(new Object[]{"callMethodA", targetNode.getTarget(), method});
    }

    public Object callMethod(IASNode targetNode, String method, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] a = new Object[args.length + 3];
        a[0] = "callMethodA";
        a[1] = targetNode.getTarget();
        a[2] = method;
        System.arraycopy(args, 0, a, 3, args.length);
        return this.invoke(a);
    }

    public IASNode[] getChildren(IASNode parentNode, boolean visual, boolean debugMode) {
        String sidMethod = visual ? "getInnerNodes" : (debugMode ? "getSuccessorNodes" : "getChildNodes");
        return this.createFlashNodeArray(this.invoke(sidMethod, parentNode.getTarget()), parentNode);
    }

    public IASNode getNodeAtDepthWithPath(String path, int depth) {
        Object result = this.invoke(new Object[]{"getNodeAtDepth", path, depth});
        if (result instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)result);
        }
        return null;
    }

    public IASNode getNodeFromPath(String path) {
        Object result = this.invoke("getNodeFromPath", path);
        if (result instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)result);
        }
        return null;
    }

    public Object getProperty(String path, String prop) {
        return this.invoke(new Object[]{"getProperty", path, prop});
    }

    public IASNode getRootNode() {
        Object result = this.invoke("getRootNode");
        if (result instanceof ASObject) {
            return new ASNodeImplV8(null, this.flashPlayer, (ASObject)result);
        }
        return null;
    }

    public boolean hasChild(IASNode parentNode, boolean visual, boolean debugMode) {
        if (visual) {
            return true;
        }
        String sidMethod = visual ? "getNumSuccessorNodes" : (debugMode ? "getNumSuccessorNodes" : "getNumChildNodes");
        Object result = this.invoke(sidMethod, parentNode.getTarget());
        if (result instanceof Integer) {
            return (Integer)result > 0;
        }
        return false;
    }

    public void repairFlash() {
        if (!this._isRepaired) {
            this._isRepaired = true;
            this.invoke("repairFlash", "_level0");
        }
    }

    public IASNode[] searchSound() {
        return this.createFlashNodeArray(this.invoke(new Object[]{"searchSound", "_level0", "_global"}), null);
    }

    public IASNode[] searchVideo() {
        return this.createFlashNodeArray(this.invoke(new Object[]{"searchVideo", "_level0", "_global"}), null);
    }

    public boolean setFocus(String target) {
        Object result = this.invoke("setFocus", target);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public boolean setMarker(Number x, Number y, Number width, Number height) {
        this.unsetMarker();
        if (x != null && y != null && width != null && height != null) {
            this.initMarker();
            if (this.objMarker != null) {
                this.invoke(new Object[]{"setMarker", this.objMarker, x, y, width, height});
                return true;
            }
        }
        return false;
    }

    public boolean setMarker(IASNode node) {
        return this.setMarker(node.getX(), node.getY(), node.getWidth(), node.getHeight());
    }

    public void setProperty(String path, String prop, Object value) {
        this.invoke(new Object[]{"setProperty", path, prop, value});
    }

    public IASNode[] translateWithPath(String path) {
        Object result = null;
        try {
            result = this.invoke("translate", path);
        }
        catch (DispatchException dispatchException) {}
        return this.createFlashNodeArray(result, null);
    }

    public boolean unsetMarker() {
        if (this.objMarker == null) {
            return false;
        }
        this.invoke("unsetMarker", this.objMarker);
        return true;
    }

    public boolean updateTarget() {
        Object result = this.invoke(new Object[]{"updateTarget", "_level0", 10});
        return result instanceof Boolean && (Boolean)result != false;
    }

    public boolean clearAllMarkers() {
        this.invoke("clearAllMarkers");
        return true;
    }
}

