/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.dialogs.WorkflowTypeSelectionDialog;
import org.eclipse.sphinx.emf.mwe.dynamic.util.XtendUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;

public class WorkflowRunnerActionHandlerHelper {
    public boolean isWorkflow(IStructuredSelection structuredSelection) {
        return this.getWorkflow(structuredSelection) != null;
    }

    public Object getWorkflow(IStructuredSelection structuredSelection) {
        if (structuredSelection == null || structuredSelection.isEmpty() && structuredSelection.size() > 1) {
            return null;
        }
        Object selected = structuredSelection.getFirstElement();
        if (selected instanceof IType) {
            return selected;
        }
        if (selected instanceof ICompilationUnit) {
            return selected;
        }
        if (selected instanceof IFile && XtendUtil.isXtendFile((IFile)((IFile)selected))) {
            return selected;
        }
        return null;
    }

    public Object promptForWorkflow(IStructuredSelection structuredSelection) {
        Object[] workflowTypes;
        WorkflowTypeSelectionDialog dialog = new WorkflowTypeSelectionDialog(ExtendedPlatformUI.getActiveShell());
        int returnCode = dialog.open();
        if (returnCode == 0 && (workflowTypes = dialog.getResult()).length > 0) {
            return workflowTypes[0];
        }
        return null;
    }

    public boolean isModel(IStructuredSelection structuredSelection) {
        for (URI uri : this.getModelURIs(structuredSelection)) {
            if (!EcoreResourceUtil.isEMFModelURI((URI)uri)) continue;
            return true;
        }
        return !this.getModelObjects(structuredSelection).isEmpty();
    }

    public List<URI> getModelURIs(IStructuredSelection structuredSelection) {
        if (structuredSelection == null) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Object selected : structuredSelection.toList()) {
            uris.addAll(this.getModelURIs(selected));
        }
        return uris;
    }

    protected List<URI> getModelURIs(Object object) {
        if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
            return Collections.singletonList(EcoreResourceUtil.getURI((EObject)((EObject)object), (boolean)true));
        }
        if (object instanceof TransientItemProvider) {
            TransientItemProvider provider = (TransientItemProvider)object;
            ArrayList<URI> uris = new ArrayList<URI>();
            for (Object child : provider.getChildren(object)) {
                uris.addAll(this.getModelURIs(child));
            }
            return uris;
        }
        URI uri = null;
        if (object instanceof IFile) {
            uri = EcorePlatformUtil.createURI((IPath)((IFile)object).getFullPath());
        }
        if (object instanceof Resource) {
            uri = ((Resource)object).getURI();
        }
        if (uri != null) {
            return Collections.singletonList(uri);
        }
        return Collections.emptyList();
    }

    protected List<EObject> getModelObjects(IStructuredSelection structuredSelection) {
        if (structuredSelection == null) {
            return Collections.emptyList();
        }
        ArrayList<EObject> modelObjects = new ArrayList<EObject>();
        for (Object selected : structuredSelection.toList()) {
            modelObjects.addAll(this.getModelObjects(selected));
        }
        return modelObjects;
    }

    protected List<EObject> getModelObjects(Object object) {
        if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
            return Collections.singletonList((EObject)object);
        }
        if (object instanceof TransientItemProvider) {
            TransientItemProvider provider = (TransientItemProvider)object;
            ArrayList<EObject> modelObjects = new ArrayList<EObject>();
            for (Object child : provider.getChildren(object)) {
                modelObjects.addAll(this.getModelObjects(child));
            }
            return modelObjects;
        }
        return Collections.emptyList();
    }
}

