/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.URIExtensions;
import org.eclipse.sphinx.emf.workspace.internal.referentialintegrity.IntermittentRemoveTracker;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;

public abstract class AbstractHierarchicalFragmentURIChangeDetectorDelegate
implements IURIChangeDetectorDelegate {
    protected final IntermittentRemoveTracker removedContentsTracker = this.createIntermittentRemoveTracker();

    protected IntermittentRemoveTracker createIntermittentRemoveTracker() {
        return new IntermittentRemoveTracker();
    }

    protected abstract boolean affectsURIFragmentSegmentOfChangedObject(Notification var1);

    @Override
    public List<URIChangeNotification> detectChangedURIs(Notification notification) {
        ArrayList<URIChangeNotification> notifications;
        block10: {
            EStructuralFeature feature;
            EObject eObject;
            block11: {
                notifications = new ArrayList<URIChangeNotification>();
                if (!(notification.getNotifier() instanceof EObject)) break block10;
                eObject = (EObject)notification.getNotifier();
                feature = (EStructuralFeature)notification.getFeature();
                if (!this.affectsURIFragmentSegmentOfChangedObject(notification)) break block11;
                URI newURI = EcoreResourceUtil.getURI((EObject)eObject);
                URI oldURI = URIExtensions.replaceLastFragmentSegment((URI)newURI, (String)notification.getNewStringValue(), (String)notification.getOldStringValue());
                if (oldURI == null || oldURI.equals(newURI)) break block10;
                this.addURIChangeNotification(notifications, eObject, oldURI, newURI);
                break block10;
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                this.removedContentsTracker.clearObsoleteEntries();
                if (4 == notification.getEventType()) {
                    URI containerURI = EcoreResourceUtil.getURI((EObject)eObject);
                    this.handleRemovedContent(eObject, containerURI, feature, (EObject)notification.getOldValue());
                } else if (3 == notification.getEventType()) {
                    this.handleAddedContent(notifications, (EObject)notification.getNewValue());
                } else if (6 == notification.getEventType()) {
                    URI containerURI = EcoreResourceUtil.getURI((EObject)eObject);
                    List oldValues = (List)notification.getOldValue();
                    for (EObject oldValue : oldValues) {
                        this.handleRemovedContent(eObject, containerURI, feature, oldValue);
                    }
                } else if (5 == notification.getEventType()) {
                    List newValues = (List)notification.getNewValue();
                    for (EObject newValue : newValues) {
                        this.handleAddedContent(notifications, newValue);
                    }
                }
            }
        }
        return notifications;
    }

    protected void handleRemovedContent(EObject oldContainer, URI oldContainerURI, EStructuralFeature oldFeature, EObject oldContent) {
        URI oldContentURI = null;
        if (oldContent.eResource() == null) {
            oldContentURI = EcoreResourceUtil.getURI((EObject)oldContainer, (EStructuralFeature)oldFeature, (EObject)oldContent);
        } else {
            URI newContentURI = EcoreResourceUtil.getURI((EObject)oldContent);
            URI newContainerURI = EcoreResourceUtil.getURI((EObject)oldContent.eContainer());
            oldContentURI = URIExtensions.replaceBaseURI((URI)newContentURI, (URI)newContainerURI, (URI)oldContainerURI);
        }
        if (oldContentURI != null) {
            this.removedContentsTracker.put(oldContent, oldContentURI);
        }
    }

    protected void handleAddedContent(List<URIChangeNotification> notifications, EObject newContent) {
        URI newContentURI;
        URI oldContentURI = (URI)this.removedContentsTracker.get(newContent);
        if (oldContentURI != null && !oldContentURI.equals(newContentURI = EcoreResourceUtil.getURI((EObject)newContent))) {
            this.addURIChangeNotification(notifications, newContent, oldContentURI, newContentURI);
        }
    }

    protected void addURIChangeNotification(List<URIChangeNotification> notifications, EObject eObject, URI oldURI, URI newURI) {
        notifications.add(new URIChangeNotification(eObject, oldURI));
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject contentObject = (EObject)eAllContents.next();
            URI newContentURI = EcoreResourceUtil.getURI((EObject)contentObject);
            URI oldContentURI = URIExtensions.replaceBaseURI((URI)newContentURI, (URI)newURI, (URI)oldURI);
            if (oldContentURI == null || oldContentURI.equals(newContentURI)) continue;
            notifications.add(new URIChangeNotification(contentObject, oldContentURI));
        }
    }

    @Override
    public List<URIChangeNotification> detectChangedURIs(IFile oldFile, IFile newFile) {
        return Collections.emptyList();
    }
}

