/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterByPredicateObject;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetClass
extends Target {
    private final Set<Resource> targetClass;

    public TargetClass(Set<Resource> targetClass) {
        this.targetClass = targetClass;
        assert (!this.targetClass.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_CLASS;
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope, connectionsGroup);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope, ConnectionsGroup connectionsGroup) {
        PlanNode planNode;
        if (this.targetClass.size() == 1) {
            Resource clazz = (Resource)this.targetClass.stream().findAny().get();
            planNode = new UnorderedSelect(connection, null, RDF.TYPE, (Value)clazz, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), null);
        } else {
            planNode = new Select(connection, SparqlFragment.bgp(Set.of(), this.getQueryFragment("?a", "?c", null, new StatementMatcher.StableRandomVariableProvider())), "?a", b -> new ValidationTuple(b.getValue("a"), scope, false, dataGraph), dataGraph);
        }
        return Unique.getInstance(planNode, false, connectionsGroup);
    }

    String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        Set<Object> targets = this.targetClass;
        if (rdfsSubClassOfReasoner != null) {
            targets = targets.stream().flatMap(target -> rdfsSubClassOfReasoner.backwardsChain((Resource)target).stream()).collect(Collectors.toSet());
        }
        assert (!targets.isEmpty());
        return targets.stream().map(r -> "<" + String.valueOf(r) + ">").sorted().map(r -> String.join((CharSequence)"\n", "{", "BIND(rdf:type as " + stableRandomVariableProvider.next().asSparqlVariable() + ")", "BIND(" + r + " as " + objectVariable + ")", subjectVariable + " " + stableRandomVariableProvider.current().asSparqlVariable() + objectVariable + ".", "}")).reduce((l, r) -> l + " UNION " + r).get();
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        if (connectionsGroup.hasAddedStatements()) {
            BufferedSplitter bufferedSplitter = BufferedSplitter.getInstance(parent);
            FilterByPredicateObject typeFoundInAdded = new FilterByPredicateObject(connectionsGroup.getAddedStatements(), dataGraph, RDF.TYPE, this.targetClass, bufferedSplitter.getPlanNode(), true, FilterByPredicateObject.FilterOn.activeTarget, false, connectionsGroup);
            FilterByPredicateObject typeNotFoundInAdded = new FilterByPredicateObject(connectionsGroup.getAddedStatements(), dataGraph, RDF.TYPE, this.targetClass, bufferedSplitter.getPlanNode(), false, FilterByPredicateObject.FilterOn.activeTarget, false, connectionsGroup);
            FilterByPredicateObject filterAgainstBaseConnection = new FilterByPredicateObject(connectionsGroup.getBaseConnection(), dataGraph, RDF.TYPE, this.targetClass, typeNotFoundInAdded, true, FilterByPredicateObject.FilterOn.activeTarget, true, connectionsGroup);
            return new Sort(UnionNode.getInstance(connectionsGroup, typeFoundInAdded, filterAgainstBaseConnection), connectionsGroup);
        }
        return new FilterByPredicateObject(connectionsGroup.getBaseConnection(), dataGraph, RDF.TYPE, this.targetClass, parent, true, FilterByPredicateObject.FilterOn.activeTarget, true, connectionsGroup);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetClass.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        assert (subject == null);
        Collection<Object> targetClass = rdfsSubClassOfReasoner != null ? (this.targetClass.size() == 1 ? rdfsSubClassOfReasoner.backwardsChain((Resource)this.targetClass.toArray()[0]) : (Collection)this.targetClass.stream().map(rdfsSubClassOfReasoner::backwardsChain).flatMap(Collection::stream).collect(Collectors.toSet())) : this.targetClass;
        List<StatementMatcher> statementMatchers = targetClass.stream().map(t -> new StatementMatcher(object, new StatementMatcher.Variable<IRI>(RDF.TYPE), new StatementMatcher.Variable<Resource>((Resource)t), this, Set.of())).collect(Collectors.toList());
        if (targetClass.size() == 1) {
            String queryFragment = targetClass.stream().findFirst().map(r -> object.asSparqlVariable() + " a <" + String.valueOf(r) + "> .").orElseThrow(IllegalStateException::new);
            return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
        }
        String in = targetClass.stream().map(r -> "<" + String.valueOf(r) + ">").sorted().reduce((a, b) -> a + " , " + b).orElse("");
        String randomSparqlVariable = stableRandomVariableProvider.next().asSparqlVariable();
        String queryFragment = object.asSparqlVariable() + " a " + randomSparqlVariable + ".\nFILTER(" + randomSparqlVariable + " in ( " + in + " ))";
        return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetClass that = (TargetClass)o;
        return this.targetClass.equals(that.targetClass);
    }

    public int hashCode() {
        return Objects.hash(this.targetClass) + "TargetClass".hashCode();
    }
}

