/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.processor;

import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.flattening.Flattening;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.processor.CompactionProcessor;
import no.hasmac.jsonld.processor.ExpansionProcessor;

public final class FlatteningProcessor {
    private FlatteningProcessor() {
    }

    public static JsonStructure flatten(URI input, URI context, JsonLdOptions options) throws JsonLdError {
        if (context == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, input);
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + String.valueOf(context) + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static JsonStructure flatten(Document input, URI context, JsonLdOptions options) throws JsonLdError {
        if (context == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, context);
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + String.valueOf(context) + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static JsonStructure flatten(URI input, Document context, JsonLdOptions options) throws JsonLdError {
        FlatteningProcessor.assertDocumentLoader(options, input);
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return FlatteningProcessor.flatten(remoteDocument, context, options);
    }

    public static JsonStructure flatten(Document input, Document context, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray flattenedOutput = Flattening.with((JsonStructure)expandedInput).ordered(options.isOrdered()).flatten();
        if (context != null) {
            JsonDocument document = JsonDocument.of(MediaType.JSON_LD, (JsonStructure)flattenedOutput);
            JsonLdOptions compactionOptions = new JsonLdOptions(options);
            if (options.getBase() != null) {
                compactionOptions.setBase(options.getBase());
            } else if (options.isCompactArrays()) {
                compactionOptions.setBase(input.getDocumentUrl());
            }
            flattenedOutput = CompactionProcessor.compact((Document)document, context, compactionOptions);
        }
        return flattenedOutput;
    }

    private static void assertDocumentLoader(JsonLdOptions options, URI target) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(target) + "].");
        }
    }
}

