/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.URIUtil;

public class ValidatingValueFactory
implements ValueFactory {
    private static final int[][] PN_CHARS_U = new int[][]{{48, 57}, {95, 95}, {65, 90}, {97, 122}, {192, 214}, {216, 246}, {248, 767}, {880, 893}, {895, 8191}, {8204, 8205}, {8304, 8591}, {11264, 12271}, {12289, 55295}, {63744, 64975}, {65008, 65533}, {65536, 983039}};
    private static final int[][] PN_CHARS = new int[][]{{45, 45}, {183, 183}, {768, 879}, {8255, 8256}, {48, 57}, {95, 95}, {65, 90}, {97, 122}, {192, 214}, {216, 246}, {248, 767}, {880, 893}, {895, 8191}, {8204, 8205}, {8304, 8591}, {11264, 12271}, {12289, 55295}, {63744, 64975}, {65008, 65533}, {65536, 983039}};
    private final ValueFactory delegate;

    public ValidatingValueFactory() {
        this(SimpleValueFactory.getInstance());
    }

    public ValidatingValueFactory(ValueFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public IRI createIRI(String iri) {
        try {
            if (!new ParsedIRI(iri).isAbsolute()) {
                throw new IllegalArgumentException("IRI must be absolute");
            }
            return this.delegate.createIRI(iri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public IRI createIRI(String namespace, String localName) {
        if (!URIUtil.isCorrectURISplit(namespace, localName)) {
            return this.createIRI(namespace + localName);
        }
        try {
            if (!new ParsedIRI(namespace + localName).isAbsolute()) {
                throw new IllegalArgumentException("Namespace must be absolute");
            }
            return this.delegate.createIRI(namespace, localName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BNode createBNode(String nodeID) {
        if (nodeID.length() < 1) {
            throw new IllegalArgumentException("Blank node ID cannot be empty");
        }
        if (!this.isMember(PN_CHARS_U, nodeID.codePointAt(0))) {
            throw new IllegalArgumentException("Blank node ID must start with alphanumber or underscore");
        }
        int n = nodeID.codePointCount(0, nodeID.length());
        for (int i = 0; i < n; ++i) {
            if (this.isMember(PN_CHARS, nodeID.codePointAt(nodeID.offsetByCodePoints(0, i)))) continue;
            throw new IllegalArgumentException("Illegal blank node ID character");
        }
        return this.delegate.createBNode(nodeID);
    }

    @Override
    public Literal createLiteral(String label, IRI datatype) {
        if (!XMLDatatypeUtil.isValidValue(label, datatype)) {
            throw new IllegalArgumentException("Not a valid literal value");
        }
        return this.delegate.createLiteral(label, datatype);
    }

    @Override
    public Literal createLiteral(String label, CoreDatatype datatype) {
        if (!XMLDatatypeUtil.isValidValue(label, datatype)) {
            throw new IllegalArgumentException("Not a valid literal value");
        }
        return this.delegate.createLiteral(label, datatype);
    }

    @Override
    public Literal createLiteral(String label, IRI datatype, CoreDatatype coreDatatype) {
        if (!XMLDatatypeUtil.isValidValue(label, coreDatatype)) {
            throw new IllegalArgumentException("Not a valid literal value");
        }
        return this.delegate.createLiteral(label, datatype, coreDatatype);
    }

    @Override
    public Literal createLiteral(String label, String language) {
        if (!Literals.isValidLanguageTag(language)) {
            throw new IllegalArgumentException("Not a valid language tag: " + language);
        }
        return this.delegate.createLiteral(label, language);
    }

    @Override
    public BNode createBNode() {
        return this.delegate.createBNode();
    }

    @Override
    public Literal createLiteral(String label) {
        return this.delegate.createLiteral(label);
    }

    @Override
    public Literal createLiteral(boolean value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(byte value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(short value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(int value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(long value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(float value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(double value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(BigDecimal bigDecimal) {
        return this.delegate.createLiteral(bigDecimal);
    }

    @Override
    public Literal createLiteral(BigInteger bigInteger) {
        return this.delegate.createLiteral(bigInteger);
    }

    @Override
    public Literal createLiteral(TemporalAccessor value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(TemporalAmount value) {
        return this.delegate.createLiteral(value);
    }

    @Override
    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.delegate.createLiteral(calendar);
    }

    @Override
    public Literal createLiteral(Date date) {
        return this.delegate.createLiteral(date);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        return this.delegate.createStatement(subject, predicate, object);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        return this.delegate.createStatement(subject, predicate, object, context);
    }

    @Override
    public Triple createTriple(Resource subject, IRI predicate, Value object) {
        return this.delegate.createTriple(subject, predicate, object);
    }

    private boolean isMember(int[][] set, int cp) {
        for (int i = 0; i < set.length; ++i) {
            if (set[i][0] > cp || cp > set[i][1]) continue;
            return true;
        }
        return false;
    }
}

