/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Sort;

public class PlanNodeHelper {
    private static final SimpleDataset rdf4jNilDataset = new SimpleDataset();

    public static PlanNode handleSorting(PlanNode child, PlanNode parent) {
        return PlanNodeHelper.handleSorting(child.requiresSorted(), parent);
    }

    public static PlanNode handleSorting(boolean requiresSorted, PlanNode parent) {
        if (requiresSorted && !parent.producesSorted()) {
            parent = new Sort(parent);
        }
        return parent;
    }

    public static Dataset asDefaultGraphDataset(Resource[] dataGraph) {
        if (dataGraph.length == 0) {
            return AllDataset.instance;
        }
        if (dataGraph.length == 1 && dataGraph[0] == null) {
            return rdf4jNilDataset;
        }
        SimpleDataset dataGraphDataset = new SimpleDataset();
        for (Resource context : dataGraph) {
            if (context == null) {
                dataGraphDataset.addDefaultGraph(RDF4J.NIL);
                continue;
            }
            if (context.isIRI()) {
                dataGraphDataset.addDefaultGraph((IRI)context);
                continue;
            }
            throw new IllegalArgumentException("Trying to validate a data graph that is not an IRI.");
        }
        return dataGraphDataset;
    }

    static {
        rdf4jNilDataset.addDefaultGraph(RDF4J.NIL);
    }

    static final class AllDataset
    implements Dataset {
        static final AllDataset instance = new AllDataset();
        private static final Set<IRI> empty = Set.of();

        AllDataset() {
        }

        public Set<IRI> getDefaultRemoveGraphs() {
            return empty;
        }

        public IRI getDefaultInsertGraph() {
            return null;
        }

        public Set<IRI> getDefaultGraphs() {
            return empty;
        }

        public Set<IRI> getNamedGraphs() {
            return empty;
        }
    }
}

