/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MinLengthFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class MinLengthConstraintComponent
extends SimpleAbstractConstraintComponent {
    long minLength;

    public MinLengthConstraintComponent(long minLength) {
        this.minLength = minLength;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MIN_LENGTH, (Value)Values.literal((BigInteger)BigInteger.valueOf(this.minLength)), new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return "STRLEN(STR(" + variable.asSparqlVariable() + ")) >= " + this.minLength;
        }
        return "STRLEN(STR(" + variable.asSparqlVariable() + ")) < " + this.minLength;
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new MinLengthFilter((PlanNode)parent, this.minLength);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MinLengthConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MinLengthConstraintComponent(this.minLength);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinLengthConstraintComponent that = (MinLengthConstraintComponent)o;
        return this.minLength == that.minLength;
    }

    public int hashCode() {
        return (int)(this.minLength ^ this.minLength >>> 32) + "MinLengthConstraintComponent".hashCode();
    }
}

