/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class NumericLiteral
extends AbstractLiteral {
    private static final long serialVersionUID = 3004497457768807919L;
    private final Number number;
    private final CoreDatatype datatype;

    protected NumericLiteral(Number number, IRI datatype) {
        assert (Objects.nonNull(number));
        assert (Objects.nonNull(datatype));
        this.datatype = CoreDatatype.from((IRI)datatype);
        this.number = number;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    protected NumericLiteral(Number number, XSD.Datatype datatype) {
        this(number, datatype.getCoreDatatype());
    }

    protected NumericLiteral(Number number, CoreDatatype datatype) {
        this.datatype = datatype;
        this.number = number;
    }

    protected NumericLiteral(byte number) {
        this((Number)number, (CoreDatatype)CoreDatatype.XSD.BYTE);
    }

    protected NumericLiteral(short number) {
        this((Number)number, (CoreDatatype)CoreDatatype.XSD.SHORT);
    }

    protected NumericLiteral(int number) {
        this((Number)number, (CoreDatatype)CoreDatatype.XSD.INT);
    }

    protected NumericLiteral(long n) {
        this((Number)n, (CoreDatatype)CoreDatatype.XSD.LONG);
    }

    protected NumericLiteral(float n) {
        this((Number)Float.valueOf(n), (CoreDatatype)CoreDatatype.XSD.FLOAT);
    }

    protected NumericLiteral(double n) {
        this((Number)n, (CoreDatatype)CoreDatatype.XSD.DOUBLE);
    }

    public byte byteValue() {
        return this.number.byteValue();
    }

    public short shortValue() {
        return this.number.shortValue();
    }

    public int intValue() {
        return this.number.intValue();
    }

    public long longValue() {
        return this.number.longValue();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public String getLabel() {
        return XMLDatatypeUtil.toString(this.number);
    }

    public Optional<String> getLanguage() {
        return Optional.empty();
    }

    public IRI getDatatype() {
        return this.datatype.getIri();
    }

    public CoreDatatype getCoreDatatype() {
        return this.datatype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NumericLiteral) {
            return this.datatype == ((NumericLiteral)((Object)o)).datatype && this.number.equals(((NumericLiteral)((Object)o)).number);
        }
        return super.equals(o);
    }
}

