/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.core.query.GraphManagementQuery;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;

public abstract class TargetedGraphManagementQuery<T extends TargetedGraphManagementQuery<T>>
extends GraphManagementQuery<TargetedGraphManagementQuery<T>> {
    private static final String GRAPH = "GRAPH";
    private static final String DEFAULT = "DEFAULT";
    private static final String NAMED = "NAMED";
    private static final String ALL = "ALL";
    private String target = "DEFAULT";
    private Optional<Iri> graph = Optional.empty();

    public T graph(Iri graph) {
        this.graph = Optional.ofNullable(graph);
        return (T)this;
    }

    public T graph(IRI graph) {
        return this.graph(Rdf.iri(graph));
    }

    public T def() {
        return this.target(DEFAULT);
    }

    public T named() {
        return this.target(NAMED);
    }

    public T all() {
        return this.target(ALL);
    }

    private T target(String target) {
        this.target = target;
        this.graph = Optional.empty();
        return (T)this;
    }

    protected abstract String getQueryActionString();

    @Override
    public String getQueryString() {
        StringBuilder query = new StringBuilder();
        query.append(this.getQueryActionString()).append(" ");
        this.appendSilent(query);
        String targetString = this.graph.map(iri -> "GRAPH " + iri.getQueryString()).orElse(this.target);
        query.append(targetString);
        return query.toString();
    }
}

