/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;

class MemNamespaceStore
implements Iterable<SimpleNamespace> {
    private final Map<String, SimpleNamespace> namespacesMap = new LinkedHashMap<String, SimpleNamespace>(16);

    MemNamespaceStore() {
    }

    public String getNamespace(String prefix) {
        String result = null;
        SimpleNamespace namespace = this.namespacesMap.get(prefix);
        if (namespace != null) {
            result = namespace.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name) {
        SimpleNamespace ns = this.namespacesMap.get(prefix);
        if (ns != null) {
            ns.setName(name);
        } else {
            this.namespacesMap.put(prefix, new SimpleNamespace(prefix, name));
        }
    }

    public void removeNamespace(String prefix) {
        this.namespacesMap.remove(prefix);
    }

    @Override
    public Iterator<SimpleNamespace> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        this.namespacesMap.clear();
    }
}

