/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.lucene.AbstractSearchQueryEvaluator;

public class QuerySpec
extends AbstractSearchQueryEvaluator {
    private final StatementPattern matchesPattern;
    private final Collection<QueryParam> queryPatterns;
    private final StatementPattern scorePattern;
    private final StatementPattern typePattern;
    private final StatementPattern idPattern;
    private final Resource subject;
    private final String matchesVarName;
    private final String scoreVarName;

    private static void replace(QueryModelNode pattern, Supplier<? extends QueryModelNode> replacement) {
        if (pattern != null) {
            pattern.replaceWith(replacement.get());
        }
    }

    private static void append(StatementPattern pattern, StringBuilder buffer) {
        if (pattern == null) {
            return;
        }
        buffer.append("   ");
        buffer.append("StatementPattern\n");
        QuerySpec.append(pattern.getSubjectVar(), buffer);
        QuerySpec.append(pattern.getPredicateVar(), buffer);
        QuerySpec.append(pattern.getObjectVar(), buffer);
    }

    private static void append(Var var, StringBuilder buffer) {
        buffer.append("      ");
        buffer.append(var.toString());
    }

    public QuerySpec(StatementPattern matchesPattern, Collection<QueryParam> queryPatterns, StatementPattern scorePattern, StatementPattern typePattern, StatementPattern idPattern, Resource subject) {
        this.matchesPattern = matchesPattern;
        this.queryPatterns = queryPatterns;
        this.scorePattern = scorePattern;
        this.typePattern = typePattern;
        this.idPattern = idPattern;
        this.subject = subject;
        this.matchesVarName = matchesPattern != null ? matchesPattern.getSubjectVar().getName() : null;
        this.scoreVarName = scorePattern != null ? scorePattern.getObjectVar().getName() : null;
    }

    public QuerySpec(String matchesVarName, String propertyVarName, String scoreVarName, String snippetVarName, Resource subject, String queryString, IRI propertyURI) {
        this.matchesVarName = matchesVarName;
        this.scoreVarName = scoreVarName;
        this.matchesPattern = null;
        this.scorePattern = null;
        this.typePattern = null;
        this.queryPatterns = Set.of();
        this.idPattern = null;
        this.subject = subject;
    }

    @Override
    public QueryModelNode getParentQueryModelNode() {
        return this.getMatchesPattern();
    }

    @Override
    public QueryModelNode removeQueryPatterns() {
        Supplier<QueryModelNode> replacement = SingletonSet::new;
        for (QueryParam param : this.getQueryPatterns()) {
            param.removeQueryPatterns();
        }
        QuerySpec.replace(this.getScorePattern(), replacement);
        QuerySpec.replace(this.getTypePattern(), replacement);
        QuerySpec.replace(this.getIdPattern(), replacement);
        SingletonSet placeholder = new SingletonSet();
        this.getMatchesPattern().replaceWith(placeholder);
        return placeholder;
    }

    public StatementPattern getMatchesPattern() {
        return this.matchesPattern;
    }

    public String getMatchesVariableName() {
        return this.matchesVarName;
    }

    public Collection<QueryParam> getQueryPatterns() {
        return this.queryPatterns;
    }

    public StatementPattern getIdPattern() {
        return this.idPattern;
    }

    public StatementPattern getScorePattern() {
        return this.scorePattern;
    }

    public String getScoreVariableName() {
        return this.scoreVarName;
    }

    public StatementPattern getTypePattern() {
        return this.typePattern;
    }

    public IRI getQueryType() {
        if (this.typePattern != null) {
            return (IRI)this.typePattern.getObjectVar().getValue();
        }
        return null;
    }

    public Resource getSubject() {
        return this.subject;
    }

    public boolean isEvaluable() {
        return this.queryPatterns.stream().allMatch(QueryParam::isEvaluable);
    }

    public boolean isHighlight() {
        return this.queryPatterns.stream().anyMatch(QueryParam::isHighlight);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QuerySpec\n");
        buffer.append("   subject=" + this.subject + "\n");
        QuerySpec.append(this.matchesPattern, buffer);
        buffer.append("   queryPatterns=").append(this.queryPatterns);
        QuerySpec.append(this.scorePattern, buffer);
        QuerySpec.append(this.typePattern, buffer);
        return buffer.toString();
    }

    public String getCatQuery() {
        return this.getQueryPatterns().stream().map(q -> {
            StringBuilder buffer = new StringBuilder();
            buffer.append('\"').append(q.getQuery()).append('\"');
            if (q.getProperty() != null) {
                buffer.append("@<").append(q.getProperty()).append(">");
            }
            if (q.getBoost() != null) {
                buffer.append('^').append(q.getBoost());
            }
            return buffer.toString();
        }).collect(Collectors.joining(" "));
    }

    public static class QueryParam {
        private final StatementPattern fieldPattern;
        private final StatementPattern queryPattern;
        private final StatementPattern propertyPattern;
        private final StatementPattern snippetPattern;
        private final StatementPattern boostPattern;
        private final StatementPattern typePattern;
        private final String query;
        private final Float boost;
        private final IRI property;
        private final String snippetVarName;
        private final String propertyVarName;

        public QueryParam(StatementPattern queryPattern, StatementPattern propertyPattern, StatementPattern snippetPattern, StatementPattern typePattern, String query, IRI property, Float boost) {
            this(null, queryPattern, propertyPattern, snippetPattern, null, typePattern, query, property, boost);
        }

        public QueryParam(StatementPattern fieldPattern, StatementPattern queryPattern, StatementPattern propertyPattern, StatementPattern snippetPattern, StatementPattern boostPattern, StatementPattern typePattern, String query, IRI property, Float boost) {
            this.fieldPattern = fieldPattern;
            this.queryPattern = queryPattern;
            this.propertyPattern = propertyPattern;
            this.snippetPattern = snippetPattern;
            this.boostPattern = boostPattern;
            this.typePattern = typePattern;
            this.query = query;
            this.property = property;
            this.boost = boost;
            this.snippetVarName = snippetPattern != null ? snippetPattern.getObjectVar().getName() : null;
            this.propertyVarName = propertyPattern != null ? propertyPattern.getObjectVar().getName() : null;
        }

        public void removeQueryPatterns() {
            Supplier<QueryModelNode> replacement = SingletonSet::new;
            QuerySpec.replace(this.getTypePattern(), replacement);
            QuerySpec.replace(this.getQueryPattern(), replacement);
            QuerySpec.replace(this.getPropertyPattern(), replacement);
            QuerySpec.replace(this.getSnippetPattern(), replacement);
            QuerySpec.replace(this.getBoostPattern(), replacement);
            QuerySpec.replace(this.getFieldPattern(), replacement);
        }

        public StatementPattern getTypePattern() {
            return this.typePattern;
        }

        public StatementPattern getFieldPattern() {
            return this.fieldPattern;
        }

        public StatementPattern getQueryPattern() {
            return this.queryPattern;
        }

        public StatementPattern getPropertyPattern() {
            return this.propertyPattern;
        }

        public StatementPattern getSnippetPattern() {
            return this.snippetPattern;
        }

        public StatementPattern getBoostPattern() {
            return this.boostPattern;
        }

        public String getQuery() {
            return this.query;
        }

        public IRI getProperty() {
            return this.property;
        }

        public String getPropertyVarName() {
            return this.propertyVarName;
        }

        public String getSnippetVarName() {
            return this.snippetVarName;
        }

        public Float getBoost() {
            return this.boost;
        }

        public boolean isHighlight() {
            return this.getSnippetVarName() != null || this.getPropertyVarName() != null;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("QueryParam");
            QuerySpec.append(this.fieldPattern, buffer);
            QuerySpec.append(this.queryPattern, buffer);
            QuerySpec.append(this.propertyPattern, buffer);
            QuerySpec.append(this.snippetPattern, buffer);
            QuerySpec.append(this.boostPattern, buffer);
            return buffer.toString();
        }

        public boolean isEvaluable() {
            return this.query != null;
        }
    }
}

