/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Writer out;
    protected int indentationLevel = 0;
    private String indentationString = "\t";
    private boolean indentationWritten = false;
    private int charactersSinceEOL;

    public IndentingWriter(Writer out) {
        this.out = out;
    }

    public void setIndentationString(String indentString) {
        this.indentationString = indentString;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public int getCharactersSinceEOL() {
        return this.charactersSinceEOL;
    }

    public void increaseIndentation() {
        ++this.indentationLevel;
    }

    public void decreaseIndentation() {
        --this.indentationLevel;
    }

    public void writeEOL() throws IOException {
        this.write(LINE_SEPARATOR);
        this.indentationWritten = false;
        this.charactersSinceEOL = 0;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (!this.indentationWritten) {
            for (int i = 0; i < this.indentationLevel; ++i) {
                this.out.write(this.indentationString);
            }
            this.indentationWritten = true;
        }
        this.charactersSinceEOL += len;
        this.out.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.indentationWritten) {
            for (int i = 0; i < this.indentationLevel; ++i) {
                this.out.write(this.indentationString);
            }
            this.indentationWritten = true;
        }
        this.charactersSinceEOL += len;
        this.out.write(cbuf, off, len);
    }
}

