/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import java.lang.ref.Cleaner;
import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class CleanerTupleQueryResult
implements TupleQueryResult {
    private static final Logger logger = LoggerFactory.getLogger(CleanerTupleQueryResult.class);
    private final TupleQueryResult delegate;
    private final Cleaner.Cleanable cleanable;
    private final CleanableState state;

    public CleanerTupleQueryResult(TupleQueryResult delegate, ConcurrentCleaner cleaner) {
        this.delegate = delegate;
        this.state = new CleanableState(delegate);
        this.cleanable = cleaner.register(this, this.state);
    }

    @Override
    public void close() {
        this.state.close();
        this.cleanable.clean();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public BindingSet next() {
        return (BindingSet)this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public List<String> getBindingNames() throws QueryEvaluationException {
        return this.delegate.getBindingNames();
    }

    private static final class CleanableState
    implements Runnable {
        private final TupleQueryResult iteration;
        private boolean closed = false;

        public CleanableState(TupleQueryResult iteration) {
            this.iteration = iteration;
        }

        @Override
        public void run() {
            if (!this.closed) {
                try {
                    logger.warn("Forced closing of unclosed iteration. Set the system property 'org.eclipse.rdf4j.repository.debug' to 'true' to get stack traces.");
                    this.iteration.close();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        public void close() {
            this.closed = true;
            this.iteration.close();
        }
    }
}

