/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

public interface Lock {
    public boolean isActive();

    public void release();

    public static interface ExtendedSupplier<T extends Lock>
    extends Supplier<T> {
        public T tryLock();

        public static <T extends Lock> Wrapper<T> wrap(Supplier<T> getLockSupplier, Supplier<T> tryLockSupplier) {
            return new Wrapper<T>(getLockSupplier, tryLockSupplier);
        }

        public static class Wrapper<T extends Lock>
        implements ExtendedSupplier<T> {
            Supplier<T> getLockSupplier;
            Supplier<T> tryLockSupplier;

            private Wrapper(Supplier<T> getLockSupplier, Supplier<T> tryLockSupplier) {
                this.getLockSupplier = getLockSupplier;
                this.tryLockSupplier = tryLockSupplier;
            }

            @Override
            public T tryLock() {
                try {
                    return this.tryLockSupplier.getLock();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public T getLock() throws InterruptedException {
                return this.getLockSupplier.getLock();
            }
        }
    }

    public static interface Supplier<T extends Lock> {
        public T getLock() throws InterruptedException;
    }
}

