/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.CompressionEncodingFilter;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerChain;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.State;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;
import org.glassfish.grizzly.http.server.jmxbase.JmxEventListener;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

public class HttpServer {
    private static final Logger LOGGER = Grizzly.logger(HttpServer.class);
    private final ServerConfiguration serverConfig = new ServerConfiguration(this);
    private State state = State.STOPPED;
    private FutureImpl<HttpServer> shutdownFuture;
    private final HttpHandlerChain httpHandlerChain = new HttpHandlerChain(this);
    private final Map<String, NetworkListener> listeners = new HashMap<String, NetworkListener>(2);
    private volatile ExecutorService auxExecutorService;
    volatile DelayedExecutor delayedExecutor;
    protected volatile GrizzlyJmxManager jmxManager;
    protected volatile Object managementObject;

    public final ServerConfiguration getServerConfiguration() {
        return this.serverConfig;
    }

    public synchronized void addListener(NetworkListener listener) {
        block4: {
            if (this.state == State.RUNNING) {
                this.configureListener(listener);
                if (!listener.isStarted()) {
                    try {
                        listener.start();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                        LOGGER.log(Level.SEVERE, "Failed to start listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                        LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                    }
                }
            }
        }
        this.listeners.put(listener.getName(), listener);
    }

    public synchronized NetworkListener getListener(String name) {
        return this.listeners.get(name);
    }

    public synchronized Collection<NetworkListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners.values());
    }

    public synchronized NetworkListener removeListener(String name) {
        NetworkListener listener;
        block3: {
            listener = this.listeners.remove(name);
            if (listener != null && listener.isStarted()) {
                try {
                    listener.shutdownNow();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, "Failed to shutdown listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                    LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
        return listener;
    }

    public synchronized void start() throws IOException {
        if (this.state == State.RUNNING) {
            return;
        }
        if (this.state == State.STOPPING) {
            throw new IllegalStateException("The server is currently in pending shutdown state. Wait for the shutdown to complete or force it by calling shutdownNow()");
        }
        this.state = State.RUNNING;
        this.shutdownFuture = null;
        this.configureAuxThreadPool();
        this.delayedExecutor = new DelayedExecutor(this.auxExecutorService);
        this.delayedExecutor.start();
        for (NetworkListener listener : this.listeners.values()) {
            this.configureListener(listener);
        }
        if (this.serverConfig.isJmxEnabled()) {
            this.enableJMX();
        }
        for (NetworkListener listener : this.listeners.values()) {
            try {
                listener.start();
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Failed to start listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                    LOGGER.log(Level.FINEST, ioe.toString(), ioe);
                }
                throw ioe;
            }
        }
        this.setupHttpHandler();
        if (this.serverConfig.isJmxEnabled()) {
            for (JmxEventListener l : this.serverConfig.getJmxEventListeners()) {
                l.jmxEnabled();
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "[{0}] Started.", this.getServerConfiguration().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupHttpHandler() {
        this.serverConfig.addJmxEventListener(this.httpHandlerChain);
        Object object = this.serverConfig.handlersSync;
        synchronized (object) {
            for (HttpHandler httpHandler : this.serverConfig.orderedHandlers) {
                this.httpHandlerChain.addHandler(httpHandler, this.serverConfig.handlers.get(httpHandler));
            }
        }
        this.httpHandlerChain.start();
    }

    private void tearDownHttpHandler() {
        this.httpHandlerChain.destroy();
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandlerChain;
    }

    public boolean isStarted() {
        return this.state != State.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getManagementObject(boolean clear) {
        Object object;
        if (!clear && this.managementObject == null) {
            object = this.serverConfig;
            synchronized (object) {
                if (this.managementObject == null) {
                    this.managementObject = MonitoringUtils.loadJmxObject("org.glassfish.grizzly.http.server.jmx.HttpServer", this, HttpServer.class);
                }
            }
        }
        try {
            object = this.managementObject;
            return object;
        }
        finally {
            if (clear) {
                this.managementObject = null;
            }
        }
    }

    public synchronized GrizzlyFuture<HttpServer> shutdown(long gracePeriod, TimeUnit timeUnit) {
        if (this.state != State.RUNNING) {
            return this.shutdownFuture != null ? this.shutdownFuture : Futures.createReadyFuture(this);
        }
        this.shutdownFuture = Futures.createSafeFuture();
        this.state = State.STOPPING;
        final int listenersCount = this.listeners.size();
        final FutureImpl<HttpServer> shutdownFutureLocal = this.shutdownFuture;
        EmptyCompletionHandler<NetworkListener> shutdownCompletionHandler = new EmptyCompletionHandler<NetworkListener>(){
            final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(listenersCount);
            }

            @Override
            public void completed(NetworkListener networkListener) {
                if (this.counter.decrementAndGet() == 0) {
                    try {
                        shutdownFutureLocal.result(HttpServer.this);
                    }
                    catch (Throwable e) {
                        shutdownFutureLocal.failure(e);
                    }
                }
            }
        };
        if (listenersCount > 0) {
            for (NetworkListener listener : this.listeners.values()) {
                listener.shutdown(gracePeriod, timeUnit).addCompletionHandler((CompletionHandler<NetworkListener>)shutdownCompletionHandler);
            }
        } else {
            this.shutdownNow();
            shutdownFutureLocal.result(this);
        }
        return this.shutdownFuture;
    }

    public synchronized GrizzlyFuture<HttpServer> shutdown() {
        return this.shutdown(-1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownNow() {
        block14: {
            if (this.state == State.STOPPED) {
                return;
            }
            this.state = State.STOPPED;
            try {
                if (this.serverConfig.isJmxEnabled()) {
                    for (JmxEventListener jmxEventListener : this.serverConfig.getJmxEventListeners()) {
                        jmxEventListener.jmxDisabled();
                    }
                }
                this.tearDownHttpHandler();
                String[] names = this.listeners.keySet().toArray(new String[this.listeners.size()]);
                for (String name : names) {
                    this.removeListener(name);
                }
                this.delayedExecutor.stop();
                this.delayedExecutor.destroy();
                this.delayedExecutor = null;
                this.stopAuxThreadPool();
                if (this.serverConfig.isJmxEnabled()) {
                    this.disableJMX();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
                break block14;
            }
            finally {
                for (NetworkListener networkListener : this.listeners.values()) {
                    Processor p = networkListener.getTransport().getProcessor();
                    if (!(p instanceof FilterChain)) continue;
                    ((FilterChain)p).clear();
                }
                if (this.shutdownFuture != null) {
                    this.shutdownFuture.result(this);
                }
            }
            for (NetworkListener networkListener : this.listeners.values()) {
                Processor p = networkListener.getTransport().getProcessor();
                if (!(p instanceof FilterChain)) continue;
                ((FilterChain)p).clear();
            }
            if (this.shutdownFuture != null) {
                this.shutdownFuture.result(this);
            }
        }
    }

    @Deprecated
    public void stop() {
        this.shutdownNow();
    }

    public static HttpServer createSimpleServer() {
        return HttpServer.createSimpleServer(".");
    }

    public static HttpServer createSimpleServer(String docRoot) {
        return HttpServer.createSimpleServer(docRoot, 8080);
    }

    public static HttpServer createSimpleServer(String docRoot, int port) {
        return HttpServer.createSimpleServer(docRoot, "0.0.0.0", port);
    }

    public static HttpServer createSimpleServer(String docRoot, PortRange range) {
        return HttpServer.createSimpleServer(docRoot, "0.0.0.0", range);
    }

    public static HttpServer createSimpleServer(String docRoot, SocketAddress socketAddress) {
        InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
        return HttpServer.createSimpleServer(docRoot, inetAddr.getHostName(), inetAddr.getPort());
    }

    public static HttpServer createSimpleServer(String docRoot, String host, int port) {
        return HttpServer.createSimpleServer(docRoot, host, new PortRange(port));
    }

    public static HttpServer createSimpleServer(String docRoot, String host, PortRange range) {
        HttpServer server = new HttpServer();
        ServerConfiguration config = server.getServerConfiguration();
        if (docRoot != null) {
            config.addHttpHandler((HttpHandler)new StaticHttpHandler(new String[]{docRoot}), "/");
        }
        NetworkListener listener = new NetworkListener("grizzly", host, range);
        server.addListener(listener);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableJMX() {
        if (this.jmxManager == null) {
            ServerConfiguration serverConfiguration = this.serverConfig;
            synchronized (serverConfiguration) {
                if (this.jmxManager == null) {
                    this.jmxManager = GrizzlyJmxManager.instance();
                }
            }
        }
        this.jmxManager.registerAtRoot(this.getManagementObject(false), this.serverConfig.getName());
    }

    protected void disableJMX() {
        if (this.jmxManager != null) {
            this.jmxManager.deregister(this.getManagementObject(true));
        }
    }

    private void configureListener(NetworkListener listener) {
        FilterChain chain = listener.getFilterChain();
        if (chain == null) {
            ThreadPoolConfig threadPoolConfig;
            FilterChainBuilder builder = FilterChainBuilder.stateless();
            builder.add(new TransportFilter());
            if (listener.isSecure()) {
                SSLEngineConfigurator sslConfig = listener.getSslEngineConfig();
                if (sslConfig == null) {
                    sslConfig = new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG, false, false, false);
                    listener.setSSLEngineConfig(sslConfig);
                }
                SSLBaseFilter filter = new SSLBaseFilter(sslConfig);
                builder.add(filter);
            }
            int maxHeaderSize = listener.getMaxHttpHeaderSize() == -1 ? 8192 : listener.getMaxHttpHeaderSize();
            HttpServerFilter httpServerCodecFilter = new HttpServerFilter(listener.isChunkingEnabled(), maxHeaderSize, null, listener.getKeepAlive(), null, listener.getMaxRequestHeaders(), listener.getMaxResponseHeaders());
            Set<ContentEncoding> contentEncodings = this.configureCompressionEncodings(listener);
            for (ContentEncoding contentEncoding : contentEncodings) {
                httpServerCodecFilter.addContentEncoding(contentEncoding);
            }
            httpServerCodecFilter.setAllowPayloadForUndefinedHttpMethods(this.serverConfig.isAllowPayloadForUndefinedHttpMethods());
            httpServerCodecFilter.setMaxPayloadRemainderToSkip(this.serverConfig.getMaxPayloadRemainderToSkip());
            httpServerCodecFilter.getMonitoringConfig().addProbes((HttpProbe[])this.serverConfig.getMonitoringConfig().getHttpConfig().getProbes());
            builder.add(httpServerCodecFilter);
            builder.add(new IdleTimeoutFilter(this.delayedExecutor, listener.getKeepAlive().getIdleTimeoutInSeconds(), TimeUnit.SECONDS));
            TCPNIOTransport transport = listener.getTransport();
            FileCache fileCache = listener.getFileCache();
            fileCache.initialize(this.delayedExecutor);
            FileCacheFilter fileCacheFilter = new FileCacheFilter(fileCache);
            fileCache.getMonitoringConfig().addProbes((FileCacheProbe[])this.serverConfig.getMonitoringConfig().getFileCacheConfig().getProbes());
            builder.add(fileCacheFilter);
            ServerFilterConfiguration config = new ServerFilterConfiguration(this.serverConfig);
            if (listener.isSendFileExplicitlyConfigured()) {
                config.setSendFileEnabled(listener.isSendFileEnabled());
                fileCache.setFileSendEnabled(listener.isSendFileEnabled());
            }
            if (listener.getBackendConfiguration() != null) {
                config.setBackendConfiguration(listener.getBackendConfiguration());
            }
            if (listener.getDefaultErrorPageGenerator() != null) {
                config.setDefaultErrorPageGenerator(listener.getDefaultErrorPageGenerator());
            }
            if (listener.getSessionManager() != null) {
                config.setSessionManager(listener.getSessionManager());
            }
            config.setTraceEnabled(config.isTraceEnabled() || listener.isTraceEnabled());
            config.setMaxFormPostSize(listener.getMaxFormPostSize());
            config.setMaxBufferedPostSize(listener.getMaxBufferedPostSize());
            org.glassfish.grizzly.http.server.HttpServerFilter httpServerFilter = new org.glassfish.grizzly.http.server.HttpServerFilter(config, this.delayedExecutor);
            httpServerFilter.setHttpHandler(this.httpHandlerChain);
            httpServerFilter.getMonitoringConfig().addProbes((HttpServerProbe[])this.serverConfig.getMonitoringConfig().getWebServerConfig().getProbes());
            builder.add(httpServerFilter);
            AddOn[] addons = listener.getAddOnSet().getArray();
            if (addons != null) {
                for (AddOn addon : addons) {
                    addon.setup(listener, builder);
                }
            }
            chain = builder.build();
            listener.setFilterChain(chain);
            int transactionTimeout = listener.getTransactionTimeout();
            if (transactionTimeout >= 0 && (threadPoolConfig = transport.getWorkerThreadPoolConfig()) != null) {
                threadPoolConfig.setTransactionTimeout(this.delayedExecutor, transactionTimeout, TimeUnit.SECONDS);
            }
        }
        this.configureMonitoring(listener);
    }

    protected Set<ContentEncoding> configureCompressionEncodings(NetworkListener listener) {
        CompressionConfig compressionConfig = listener.getCompressionConfig();
        if (compressionConfig.getCompressionMode() != CompressionConfig.CompressionMode.OFF) {
            GZipContentEncoding gzipContentEncoding = new GZipContentEncoding(512, 512, new CompressionEncodingFilter(compressionConfig, GZipContentEncoding.getGzipAliases()));
            LZMAContentEncoding lzmaEncoding = new LZMAContentEncoding(new CompressionEncodingFilter(compressionConfig, LZMAContentEncoding.getLzmaAliases()));
            HashSet<ContentEncoding> set = new HashSet<ContentEncoding>(2);
            set.add(gzipContentEncoding);
            set.add(lzmaEncoding);
            return set;
        }
        return Collections.emptySet();
    }

    private void configureMonitoring(NetworkListener listener) {
        TCPNIOTransport transport = listener.getTransport();
        MonitoringConfig<TransportProbe> transportMonitoringCfg = transport.getMonitoringConfig();
        MonitoringConfig<ConnectionProbe> connectionMonitoringCfg = transport.getConnectionMonitoringConfig();
        MonitoringConfig<MemoryProbe> memoryMonitoringCfg = transport.getMemoryManager().getMonitoringConfig();
        MonitoringConfig<ThreadPoolProbe> threadPoolMonitoringCfg = transport.getThreadPoolMonitoringConfig();
        transportMonitoringCfg.addProbes((TransportProbe[])this.serverConfig.getMonitoringConfig().getTransportConfig().getProbes());
        connectionMonitoringCfg.addProbes((ConnectionProbe[])this.serverConfig.getMonitoringConfig().getConnectionConfig().getProbes());
        memoryMonitoringCfg.addProbes(this.serverConfig.getMonitoringConfig().getMemoryConfig().getProbes());
        threadPoolMonitoringCfg.addProbes((ThreadPoolProbe[])this.serverConfig.getMonitoringConfig().getThreadPoolConfig().getProbes());
    }

    private void configureAuxThreadPool() {
        final AtomicInteger threadCounter = new AtomicInteger();
        this.auxExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                DefaultWorkerThread newThread = new DefaultWorkerThread(AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER, HttpServer.this.serverConfig.getName() + "-" + threadCounter.getAndIncrement(), null, r);
                newThread.setDaemon(true);
                return newThread;
            }
        });
    }

    private void stopAuxThreadPool() {
        ExecutorService localThreadPool = this.auxExecutorService;
        this.auxExecutorService = null;
        if (localThreadPool != null) {
            localThreadPool.shutdownNow();
        }
    }

    synchronized void onAddHttpHandler(HttpHandler httpHandler, HttpHandlerRegistration[] registrations) {
        if (this.isStarted()) {
            this.httpHandlerChain.addHandler(httpHandler, registrations);
        }
    }

    synchronized void onRemoveHttpHandler(HttpHandler httpHandler) {
        if (this.isStarted()) {
            this.httpHandlerChain.removeHttpHandler(httpHandler);
        }
    }
}

