/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SSMessage;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

class ServerSessionRunner {
    private static final int SERVERSESSION_RUN = 0;
    private static final int SERVERSESSION_STOP = 1;
    private static final int SERVERSESSION_CLOSE = 2;
    private static final int SERVERSESSION_RESET = 3;
    private SessionImpl session;
    private Vector serverSessionMessageQ = new Vector();
    private Object serverSessionSyncObj = new Object();
    private int serverSessionInProcess = 0;
    private Thread serverSessionThread = null;
    private boolean serverSessionInWait = false;
    private int serverSessionState = 0;
    private boolean reset = false;
    private MessageListener messageListener = null;
    protected MessageImpl currentMessage = null;

    ServerSessionRunner(SessionImpl session, MessageListener listener) {
        this.session = session;
        this.messageListener = listener;
    }

    protected MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageListener(MessageListener listener) throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new jakarta.jms.IllegalStateException(errorString, "C4048");
            }
            this.messageListener = listener;
        }
    }

    protected void run() {
        this.serverSessionProcessStart();
        this.currentMessage = null;
        int size = this.serverSessionMessageQ.size();
        this.serverSessionProcess(size);
        for (int i = 0; i < size; ++i) {
            block15: {
                try {
                    MessageImpl message;
                    this.checkState();
                    this.serverSessionPreOnMessage();
                    if (this.serverSessionState == 2 || this.reset) {
                        this.serverSessionProcess(i - size);
                        this.serverSessionMessageQ.clear();
                        break;
                    }
                    SSMessage ssm = (SSMessage)this.serverSessionMessageQ.elementAt(0);
                    this.currentMessage = message = ssm.message;
                    if (!ssm.isDMQMessage && message._isExpired()) {
                        this.serverSessionMessageQ.removeElementAt(0);
                        this.currentMessage = null;
                        this.session.acknowledgeExpired(message);
                        break block15;
                    }
                    if (ssm.serversession instanceof ServerSession) {
                        ((ServerSession)ssm.serversession).beforeMessageDelivery(message);
                    }
                    try {
                        boolean delivered = this.onMessage(message);
                        this.currentMessage = null;
                        this.serverSessionMessageQ.removeElementAt(0);
                        if (delivered) {
                            this.session.acknowledge(message);
                        }
                    }
                    catch (JMSException e) {
                        this.session.isRollbackOnly = true;
                        this.session.rollbackCause = e;
                        throw new RuntimeException(e.getMessage());
                    }
                    finally {
                        if (ssm.serversession instanceof ServerSession) {
                            ((ServerSession)ssm.serversession).afterMessageDelivery(message);
                        }
                    }
                }
                catch (Throwable e) {
                    this.session.isRollbackOnly = true;
                    this.session.rollbackCause = e;
                    this.serverSessionProcess(i - size);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e.getMessage());
                }
            }
            this.serverSessionProcess(-1);
        }
    }

    private boolean onMessage(Message message) throws JMSException {
        boolean delivered = true;
        try {
            this.messageListener.onMessage(message);
        }
        catch (RuntimeException e1) {
            ExceptionHandler.rootLogger.log(Level.WARNING, e1.getMessage(), e1);
            delivered = false;
        }
        return delivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcessStart() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new IllegalStateException(errorString);
            }
            this.serverSessionInProcess = 1;
            this.serverSessionThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcess(int size) {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (size < 0) {
                this.serverSessionInProcess += size;
            } else {
                this.serverSessionInProcess = size;
                if (this.messageListener == null) {
                    this.serverSessionInProcess = 0;
                }
            }
            if (this.serverSessionInProcess <= 0) {
                this.serverSessionInProcess = 0;
                this.serverSessionThread = null;
                this.currentMessage = null;
                this.serverSessionSyncObj.notifyAll();
            }
            if (this.messageListener == null) {
                String errorString = AdministeredObject.cr.getKString("C4029");
                throw new IllegalStateException(errorString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionPreOnMessage() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            while (this.serverSessionState == 1 && !this.reset) {
                try {
                    this.serverSessionInWait = true;
                    this.serverSessionSyncObj.notifyAll();
                    this.serverSessionSyncObj.wait();
                }
                catch (InterruptedException e) {
                    String errorString = AdministeredObject.cr.getKString("C4047");
                    throw new RuntimeException(errorString);
                }
                finally {
                    this.serverSessionInWait = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionRun() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionState = 0;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serverSessionStop() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 1;
                return;
            }
            if (this.serverSessionThread != Thread.currentThread()) {
                this.serverSessionState = 1;
                try {
                    long waittime = 0L;
                    while (this.serverSessionInProcess > 0 && !this.serverSessionInWait && this.serverSessionState == 1) {
                        if (waittime % 15000L == 0L) {
                            waittime = 0L;
                            SessionImpl.sessionLogger.log(Level.INFO, "Waiting for ServerSession runner" + this + " to stop ...");
                        }
                        this.serverSessionSyncObj.wait(1000L);
                        waittime += 1000L;
                    }
                }
                catch (InterruptedException e) {
                    if (this.serverSessionInProcess <= 0 || this.serverSessionInWait || this.serverSessionState != 1) return;
                    ExceptionHandler.handleException((Exception)e, "C4047");
                }
            } else {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new jakarta.jms.IllegalStateException(errorString, "C4048");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionClose() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 2;
                return;
            }
            this.serverSessionStop();
            this.serverSessionState = 2;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    protected void loadMessage(MessageImpl message, jakarta.jms.ServerSession ss, boolean isDMQMessage) {
        if (this.isReset()) {
            this.clear();
        }
        this.serverSessionMessageQ.addElement(new SSMessage(message, ss, isDMQMessage));
    }

    protected Thread getCurrentThread() {
        return this.serverSessionThread;
    }

    protected void dump(PrintStream ps) {
        ps.println("------ ServerSessionRunner dump ------");
        ps.println("session ID: " + this.session.sessionId);
        ps.println("messageListener: " + this.messageListener);
        ps.println("serverSessionInProcess: " + this.serverSessionInProcess);
        ps.println("serverSessionThread: " + this.serverSessionThread);
        ps.println("serverSessionState: " + this.serverSessionState);
        ps.println("serverSessionInWait: " + this.serverSessionInWait);
        ps.println("message queue size: " + this.serverSessionMessageQ.size());
        Enumeration enum2 = this.serverSessionMessageQ.elements();
        while (enum2.hasMoreElements()) {
            ((Traceable)enum2.nextElement()).dump(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionMessageQ.clear();
            if (this.serverSessionState == 3) {
                this.serverSessionState = 0;
            }
            this.reset = false;
        }
    }

    protected void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean resetState) {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (resetState) {
                this.serverSessionState = 3;
                this.serverSessionSyncObj.notifyAll();
                return;
            }
            if (this.serverSessionState == 2) {
                return;
            }
            this.reset = true;
            if (this.serverSessionState == 3 || this.serverSessionState == 1) {
                this.serverSessionSyncObj.notifyAll();
                return;
            }
            try {
                this.serverSessionStop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.serverSessionState == 2) {
                return;
            }
            this.serverSessionRun();
        }
    }

    private void checkState() throws Exception {
        if (this.isReset()) {
            if (this.reset) {
                return;
            }
            throw new RuntimeException("Fail-over occurred, server session must be reset.");
        }
    }

    private boolean isReset() {
        return this.serverSessionState == 3 || this.reset;
    }

    public Hashtable getDebugState(boolean verbose) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("serverSessionState", String.valueOf(this.serverSessionState));
        ht.put("serverSessionInProcess", String.valueOf(this.serverSessionInProcess));
        ht.put("serverSessionInWait", String.valueOf(this.serverSessionInWait));
        ht.put("reset", String.valueOf(this.reset));
        try {
            Thread th = this.serverSessionThread;
            ht.put("serverSessionThread", th == null ? "null" : th.toString());
            MessageListener ml = this.messageListener;
            ht.put("messageListener", ml == null ? "null" : ml.toString());
            MessageImpl msg = this.currentMessage;
            ht.put("currentMessage", msg == null ? "null" : msg.getJMSMessageID());
        }
        catch (Throwable t) {
            ExceptionHandler.logCaughtException(t);
            t.printStackTrace();
        }
        return ht;
    }
}

