/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQConnectionFilter;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacketList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.List;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class GrizzlyMQPacketDispatchFilter
extends BaseFilter {
    private final Attribute<GrizzlyMQIPConnection> connAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyMQConnectionFilter.GRIZZLY_MQIPCONNECTION_ATTR);

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyMQPacketList packetList = (GrizzlyMQPacketList)ctx.getMessage();
        List<Packet> list = packetList.getPackets();
        GrizzlyMQIPConnection conn = (GrizzlyMQIPConnection)this.connAttr.get((AttributeStorage)connection);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Packet packet = list.get(i);
                if (packet == null) {
                    Globals.getLogger().log(32, "Read null packet from connection " + connection);
                    throw new IOException("Null Packet");
                }
                conn.receivedPacket(packet);
                conn.readData();
            }
        }
        catch (BrokerException e) {
            Globals.getLogger().logStack(32, "Failed to process packet from connection " + connection, e);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            packetList.recycle(true);
        }
        return ctx.getInvokeAction();
    }
}

