/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FilePool;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

abstract class RandomAccessStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    public static final String FREE_FILE = "FREE";
    public static final String GOOD = "GOOD";
    public static final String WRITING = "....";
    public static final long START_OF_DATA = 6L;
    static final int LONG_LEN = 8;
    static final int INT_LEN = 4;
    private static final int PUT = 0;
    private static final int REMOVE = 1;
    private static final int GET = 2;
    private RAFilePool raFilePool = null;
    private FilePool filePool = null;
    public static final int LOWEST_FILE_NUM = 0;
    public int high = 1;
    public int low = 1;
    protected File directory = null;
    protected HashMap idToRAFile = new HashMap();
    protected HashMap idToFile = new HashMap();
    private static final boolean interruptSafe = Broker.isInProcess();
    private boolean scanned = false;
    private HashSet dataFiles = new HashSet();

    RandomAccessStore(File dir, int openlimit, int poollimit, int cleanratio) throws BrokerException {
        this.raFilePool = new RAFilePool(this, openlimit);
        int L2capacity = cleanratio * poollimit / 100;
        int L1capacity = poollimit - L2capacity;
        this.filePool = new FilePool(this, L1capacity, L2capacity);
        this.directory = dir;
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            this.logger.log(32, "B3017", this.directory.toString());
            throw new BrokerException(this.br.getString("B3017", this.directory.toString()), 405);
        }
    }

    abstract Object parseData(byte[] var1, byte[] var2) throws IOException;

    abstract FilenameFilter getFilenameFilter();

    protected void printFileInfo(PrintStream out) {
        this.raFilePool.printFileInfo(out);
        this.filePool.printFileInfo(out);
    }

    protected void close(boolean cleanup) {
        this.printStatistics("At close():");
        FileInfo[] info = this.idToRAFile.values().toArray(new FileInfo[this.idToRAFile.size()]);
        this.closeFiles(info, cleanup);
        if (cleanup) {
            info = this.idToFile.values().toArray(new FileInfo[this.idToFile.size()]);
            this.truncateFiles(info);
        }
        this.raFilePool.close(cleanup);
        this.filePool.close(cleanup);
    }

    void printStatistics(String msg) {
        if (Store.getDEBUG()) {
            this.logger.log(4, "class=" + this);
            this.logger.log(4, msg);
            this.logger.log(4, "high = " + this.high);
            this.logger.log(4, "low = " + this.low);
            this.logger.log(4, "idToRAFile.size = " + this.idToRAFile.size());
            this.logger.log(4, "idToFile.size = " + this.idToFile.size());
            this.raFilePool.printStatistics();
            this.filePool.printStatistics();
        }
    }

    boolean writeAttachment(Object id, byte[] buf, boolean sync) throws IOException {
        boolean ok = true;
        boolean doclose = false;
        RandomAccessFile rfile = null;
        FileInfo fileinfo = (FileInfo)this.idToRAFileOp(2, id, null);
        if (fileinfo != null) {
            rfile = (RandomAccessFile)fileinfo.file;
        } else {
            fileinfo = (FileInfo)this.idToFileOp(2, id, null);
            if (fileinfo != null) {
                rfile = new RandomAccessFile((File)fileinfo.file, "rw");
                doclose = true;
            } else {
                ok = false;
            }
        }
        if (ok) {
            this.writeAttachment(rfile, fileinfo.endofdata, buf, sync);
            fileinfo.endoffile = fileinfo.endofdata + 8L + (long)buf.length;
            if (doclose) {
                rfile.close();
            }
        }
        return ok;
    }

    boolean writeAttachmentData(Object id, long offset, int intValue, boolean sync) throws IOException {
        return this.writeAttachmentData(id, offset, false, intValue, sync);
    }

    boolean writeAttachmentData(Object id, long offset, boolean fromStart, int intValue, boolean sync) throws IOException {
        boolean ok = true;
        boolean doclose = false;
        RandomAccessFile rfile = null;
        FileInfo fileinfo = (FileInfo)this.idToRAFileOp(2, id, null);
        if (fileinfo != null) {
            rfile = (RandomAccessFile)fileinfo.file;
        } else {
            fileinfo = (FileInfo)this.idToFileOp(2, id, null);
            if (fileinfo != null) {
                rfile = new RandomAccessFile((File)fileinfo.file, "rw");
                doclose = true;
            } else {
                ok = false;
            }
        }
        if (ok) {
            long myoffset = 0L;
            myoffset = fromStart ? 14L + offset : fileinfo.endofdata + 8L + offset;
            this.writeAttachmentData(rfile, myoffset, intValue, sync);
            if (doclose) {
                rfile.close();
            }
        }
        return ok;
    }

    private void writeAttachment(RandomAccessFile rfile, long pos, byte[] buf, boolean sync) throws IOException {
        RandomAccessStore.markWriting(rfile);
        RandomAccessStore.seek(rfile, pos);
        RandomAccessStore.writeLong(rfile, buf.length);
        RandomAccessStore.write(rfile, buf);
        RandomAccessStore.markGood(rfile);
        if (sync) {
            RandomAccessStore.sync(rfile);
        }
    }

    private void writeAttachmentData(RandomAccessFile rfile, long pos, int intvalue, boolean sync) throws IOException {
        RandomAccessStore.seek(rfile, pos);
        RandomAccessStore.writeInt(rfile, intvalue);
        if (sync) {
            RandomAccessStore.sync(rfile);
        }
    }

    byte[] loadData(Object id) throws IOException {
        FileInfo info = (FileInfo)this.idToRAFileOp(2, id, null);
        byte[] data = null;
        if (info != null) {
            data = this.loadDataFromFile((RandomAccessFile)info.file);
        } else {
            info = (FileInfo)this.idToFileOp(2, id, null);
            if (info != null) {
                RandomAccessFile rfile = new RandomAccessFile((File)info.file, "r");
                data = this.loadDataFromFile(rfile);
                rfile.close();
            }
        }
        return data;
    }

    boolean removeData(Object id, boolean sync) throws IOException {
        boolean ok = true;
        FileInfo info = (FileInfo)this.idToRAFileOp(1, id, null);
        if (info != null) {
            this.raFilePool.putRAFile((RandomAccessFile)info.file, sync);
            return ok;
        }
        info = (FileInfo)this.idToFileOp(1, id, null);
        if (info != null) {
            this.filePool.putFile((File)info.file, sync);
        } else {
            ok = false;
        }
        return ok;
    }

    void removeAllData(boolean sync) throws IOException {
        boolean ok = true;
        for (FileInfo info : this.idToRAFile.values()) {
            ok = this.raFilePool.putRAFile((RandomAccessFile)info.file, sync);
        }
        this.idToRAFile.clear();
        if (!ok) {
            System.out.println("Failed to tag some file free");
        }
        for (FileInfo info : this.idToFile.values()) {
            this.filePool.putFile((File)info.file, sync);
        }
        this.idToFile.clear();
    }

    protected RandomAccessFile getRAF(Object id) throws IOException {
        FileInfo fileinfo = (FileInfo)this.idToRAFileOp(2, id, null);
        if (fileinfo != null) {
            return (RandomAccessFile)fileinfo.file;
        }
        fileinfo = (FileInfo)this.idToFileOp(2, id, null);
        if (fileinfo != null) {
            return new RandomAccessFile((File)fileinfo.file, "rw");
        }
        RandomAccessFile rfile = this.raFilePool.getRAFile();
        if (rfile != null) {
            this.idToRAFileOp(0, id, new FileInfo(rfile, 0L, 0L));
        } else {
            File file = this.filePool.getFile();
            try {
                rfile = new RandomAccessFile(file, "rw");
                this.idToFileOp(0, id, new FileInfo(file, 0L, 0L));
            }
            catch (IOException e) {
                this.filePool.putFile(file, false);
                throw e;
            }
        }
        return rfile;
    }

    protected void releaseRAF(Object id, RandomAccessFile raf, long endofdata, long endoffile) {
        FileInfo info = (FileInfo)this.idToRAFileOp(2, id, null);
        if (info == null) {
            info = (FileInfo)this.idToFileOp(2, id, null);
            if (info != null) {
                info.endofdata = endofdata;
                info.endoffile = endoffile;
            } else if (Store.getDEBUG()) {
                this.logger.log(1, "cannot find owner for raf");
            }
            try {
                raf.close();
            }
            catch (IOException e) {
                if (Store.getDEBUG()) {
                    this.logger.log(1, "failed to close RA files " + info.file, e);
                }
            }
        } else {
            info.endofdata = endofdata;
            info.endoffile = endoffile;
        }
    }

    protected void writeData(Object id, byte[] buf, byte[] attachment, boolean sync) throws IOException {
        long alen = 8 + (attachment == null ? 0 : attachment.length);
        RandomAccessFile rfile = this.raFilePool.getRAFile();
        if (rfile != null) {
            try {
                long len = this.writeData(rfile, buf, attachment, sync);
                this.idToRAFileOp(0, id, new FileInfo(rfile, len, len + alen));
            }
            catch (IOException e) {
                this.raFilePool.putRAFile(rfile, sync);
                throw e;
            }
        }
        File file = this.filePool.getFile();
        try {
            rfile = new RandomAccessFile(file, "rw");
            long len = this.writeData(rfile, buf, attachment, sync);
            this.idToFileOp(0, id, new FileInfo(file, len, len + alen));
        }
        catch (IOException e) {
            this.filePool.putFile(file, sync);
            throw e;
        }
        finally {
            block14: {
                if (rfile != null) {
                    try {
                        rfile.close();
                    }
                    catch (IOException e) {
                        if (!Store.getDEBUG()) break block14;
                        this.logger.log(1, "failed to close RA files " + file, e);
                    }
                }
            }
        }
    }

    static void markWriting(RandomAccessFile raf) throws IOException {
        RandomAccessStore.seek(raf, 0L);
        RandomAccessStore.writeUTF(raf, WRITING);
    }

    static void markGood(RandomAccessFile raf) throws IOException {
        RandomAccessStore.seek(raf, 0L);
        RandomAccessStore.writeUTF(raf, GOOD);
    }

    static void markFree(RandomAccessFile raf) throws IOException {
        RandomAccessStore.seek(raf, 0L);
        RandomAccessStore.writeUTF(raf, FREE_FILE);
    }

    private long writeData(RandomAccessFile rfile, byte[] buf, byte[] attachment, boolean sync) throws IOException {
        RandomAccessStore.markWriting(rfile);
        RandomAccessStore.writeLong(rfile, buf.length);
        RandomAccessStore.write(rfile, buf);
        long endofdata = rfile.getFilePointer();
        if (attachment == null) {
            RandomAccessStore.writeLong(rfile, 0L);
        } else {
            RandomAccessStore.writeLong(rfile, attachment.length);
            RandomAccessStore.write(rfile, attachment);
        }
        RandomAccessStore.markGood(rfile);
        if (sync) {
            RandomAccessStore.sync(rfile);
        }
        return endofdata;
    }

    private static void seek(RandomAccessFile rfile, long pos) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.seek(pos);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.seek(pos);
        }
    }

    private static void write(RandomAccessFile rfile, byte[] buf) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.write(buf);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.write(buf);
        }
    }

    private static void writeUTF(RandomAccessFile rfile, String v) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.writeUTF(v);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.writeUTF(v);
        }
    }

    private static void writeInt(RandomAccessFile rfile, int v) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.writeInt(v);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.writeInt(v);
        }
    }

    private static void writeLong(RandomAccessFile rfile, long v) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.writeLong(v);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.writeLong(v);
        }
    }

    private static void sync(RandomAccessFile rfile) throws IOException {
        if (interruptSafe) {
            boolean interrupted = false;
            try {
                interrupted = Thread.interrupted();
                rfile.getFD().sync();
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            rfile.getChannel().force(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFiles(FileInfo[] rfiles, boolean cleanup) {
        int count = 0;
        for (int i = 0; i < rfiles.length; ++i) {
            try {
                RandomAccessFile rfile;
                if (!cleanup || (rfile = (RandomAccessFile)rfiles[i].file).length() <= rfiles[i].endoffile) continue;
                rfile.setLength(rfiles[i].endoffile);
                ++count;
                continue;
            }
            catch (IOException e) {
                File file = this.raFilePool.getFile((RandomAccessFile)rfiles[i].file);
                this.logger.log(8, "B1045", (Object)(file != null ? file.toString() : ""), (Throwable)e);
                continue;
            }
            finally {
                try {
                    ((RandomAccessFile)rfiles[i].file).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "Truncated " + count + " files");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateFiles(FileInfo[] files) {
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            RandomAccessFile rfile = null;
            try {
                File file = (File)files[i].file;
                if (file.length() <= files[i].endoffile) continue;
                rfile = new RandomAccessFile((File)files[i].file, "rw");
                rfile.setLength(files[i].endoffile);
                ++count;
                continue;
            }
            catch (IOException e) {
                this.logger.log(8, "B1045", files[i].file, (Throwable)e);
                continue;
            }
            finally {
                if (rfile != null) {
                    try {
                        rfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "Truncated " + count + " files");
        }
    }

    int getNumFreeFiles() {
        return this.filePool.getNumFreeFiles() + this.raFilePool.freeFiles.size();
    }

    void reset(boolean removeTopDir) {
        this.high = 1;
        this.low = 1;
        this.raFilePool.clear();
        this.filePool.clear();
        this.idToRAFile.clear();
        this.idToFile.clear();
        try {
            FileUtil.removeFiles(this.directory, removeTopDir);
        }
        catch (IOException e) {
            this.logger.log(32, "B4149", (Object)this.directory, (Throwable)e);
        }
    }

    private void addFileNum(int num) {
        if (num >= this.high) {
            this.high = num + 1;
        } else if (num < this.low) {
            this.low = num;
        }
    }

    private void addRAFile(Object id, RandomAccessFile rfile, File file, long endofdata, long endoffile) {
        block2: {
            try {
                rfile.close();
            }
            catch (IOException e) {
                if (!Store.getDEBUG()) break block2;
                this.logger.log(4, "closing RandomAccessFile failed", e);
            }
        }
        this.idToFileOp(0, id, new FileInfo(file, endofdata, endoffile));
    }

    void addFreeRAFile(RandomAccessFile rfile, File file) {
        if (!this.raFilePool.addRAFile(rfile, file, true)) {
            block3: {
                try {
                    rfile.close();
                }
                catch (IOException e) {
                    if (!Store.getDEBUG()) break block3;
                    this.logger.log(4, "closing RandomAccessFile failed", e);
                }
            }
            this.filePool.putFile(file, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object idToFileOp(int op, Object key, Object value) {
        Object obj = null;
        HashMap hashMap = this.idToFile;
        synchronized (hashMap) {
            switch (op) {
                case 0: {
                    obj = this.idToFile.put(key, value);
                    break;
                }
                case 1: {
                    obj = this.idToFile.remove(key);
                    break;
                }
                case 2: {
                    obj = this.idToFile.get(key);
                    break;
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object idToRAFileOp(int op, Object key, Object value) {
        Object obj = null;
        HashMap hashMap = this.idToRAFile;
        synchronized (hashMap) {
            switch (op) {
                case 0: {
                    obj = this.idToRAFile.put(key, value);
                    break;
                }
                case 1: {
                    obj = this.idToRAFile.remove(key);
                    break;
                }
                case 2: {
                    obj = this.idToRAFile.get(key);
                }
            }
        }
        return obj;
    }

    void addDataFile(File file) {
        this.dataFiles.add(file);
    }

    final long[] initCountsFromIndividualFiles() {
        long[] cnts = new long[2];
        cnts[1] = 0L;
        cnts[0] = 0L;
        FileEnumeration e = new FileEnumeration(this, this.directory);
        while (e.hasMoreElements()) {
            cnts[0] = cnts[0] + 1L;
            Long len = (Long)e.nextElement();
            cnts[1] = cnts[1] + len;
        }
        this.scanned = true;
        return cnts;
    }

    final Enumeration getFileEnumeration() {
        if (!this.scanned) {
            throw new IllegalStateException(this.br.getKString("B3100", this.getClass().getSimpleName() + ".getFileEnumeration():  files in " + this.directory + " have not been scanned yet"));
        }
        return new FileEnumeration(this, this.dataFiles.iterator());
    }

    private byte[] loadDataFromFile(RandomAccessFile rfile) throws IOException {
        RandomAccessStore.seek(rfile, 0L);
        String value = rfile.readUTF();
        byte[] data = null;
        if (GOOD.equals(value)) {
            long length = rfile.readLong();
            data = new byte[(int)length];
            rfile.readFully(data);
        }
        return data;
    }

    private static class RAFilePool {
        int limit = 0;
        LinkedList freeFiles = new LinkedList();
        HashMap allRAFiles = null;
        RandomAccessStore store;
        Logger logger = Globals.getLogger();

        RAFilePool(RandomAccessStore store, int limit) {
            this.limit = limit;
            this.store = store;
            this.allRAFiles = new HashMap(limit);
            if (Store.getDEBUG()) {
                this.logger.log(4, this.getClass().getName() + ": Created new rafile pool: capacity=" + limit);
            }
        }

        synchronized RandomAccessFile getRAFile() throws IOException {
            if (this.limit == 0) {
                return null;
            }
            RandomAccessFile rfile = null;
            int size = this.freeFiles.size();
            if (size > 0) {
                return (RandomAccessFile)this.freeFiles.remove(size - 1);
            }
            if (this.allRAFiles.size() < this.limit) {
                File file = this.store.filePool.getFile();
                rfile = new RandomAccessFile(file, "rw");
                this.allRAFiles.put(rfile, file);
                return rfile;
            }
            return null;
        }

        synchronized boolean addRAFile(RandomAccessFile rfile, File file, boolean freefile) {
            if (this.limit == 0) {
                return false;
            }
            boolean ok = true;
            if (this.allRAFiles.size() < this.limit) {
                if (freefile && !this.putRAFile(rfile, false)) {
                    ok = false;
                }
                if (ok) {
                    this.allRAFiles.put(rfile, file);
                }
            } else {
                ok = false;
            }
            return ok;
        }

        synchronized boolean putRAFile(RandomAccessFile rfile, boolean sync) {
            if (rfile == null) {
                return false;
            }
            try {
                RandomAccessStore.markFree(rfile);
                if (sync) {
                    RandomAccessStore.sync(rfile);
                }
                this.freeFiles.add(rfile);
                return true;
            }
            catch (IOException e) {
                File file = (File)this.allRAFiles.remove(rfile);
                if (file != null) {
                    try {
                        rfile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Store.getDEBUG()) {
                    this.logger.log(4, "Fail to tag free file" + file, e);
                }
                return false;
            }
        }

        File getFile(RandomAccessFile rfile) {
            return (File)this.allRAFiles.get(rfile);
        }

        void clear() {
            if (this.limit == 0) {
                return;
            }
            Object[] rfiles = this.allRAFiles.keySet().toArray();
            for (int i = 0; i < rfiles.length; ++i) {
                RandomAccessFile rfile = (RandomAccessFile)rfiles[i];
                try {
                    rfile.close();
                    continue;
                }
                catch (IOException e) {
                    if (!Store.getDEBUG()) continue;
                    this.logger.log(1, "Got exception while closing file", e);
                }
            }
            this.freeFiles.clear();
            this.allRAFiles.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean cleanup) {
            if (this.limit == 0) {
                return;
            }
            RandomAccessFile[] rfiles = this.freeFiles.toArray(new RandomAccessFile[this.freeFiles.size()]);
            for (int i = 0; i < rfiles.length; ++i) {
                File file = (File)this.allRAFiles.remove(rfiles[i]);
                try {
                    if (!cleanup) continue;
                    try {
                        if (rfiles[i].length() == 0L) continue;
                        rfiles[i].setLength(0L);
                    }
                    catch (IOException e) {
                        if (!Store.getDEBUG()) continue;
                        this.logger.log(4, "truncate file failed for " + (file != null ? file.toString() : ""));
                    }
                    continue;
                }
                finally {
                    block11: {
                        try {
                            rfiles[i].close();
                        }
                        catch (IOException e) {
                            if (!Store.getDEBUG()) break block11;
                            this.logger.log(4, "failed to close " + file);
                        }
                    }
                }
            }
        }

        void printFileInfo(PrintStream out) {
            out.println("number of opened files: " + this.allRAFiles.size());
            out.println("number of available opened files: " + this.freeFiles.size());
        }

        void printStatistics() {
            if (Store.getDEBUG()) {
                this.logger.log(4, "total number of opened files=" + this.allRAFiles.size());
                this.logger.log(4, "number of free files = " + this.freeFiles.size());
            }
        }
    }

    private static class FileInfo {
        Object file;
        long endofdata;
        long endoffile;

        FileInfo(Object afile, long endofdata, long endoffile) {
            this.file = afile;
            this.endofdata = endofdata;
            this.endoffile = endoffile;
        }
    }

    private static class FileEnumeration
    implements Enumeration {
        RandomAccessStore parent = null;
        boolean peekonly = false;
        String[] filelist = null;
        File directory = null;
        int index = 0;
        Object obj = null;
        Iterator itr = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();

        FileEnumeration(RandomAccessStore p, Iterator i) {
            this.parent = p;
            this.peekonly = false;
            this.itr = i;
        }

        FileEnumeration(RandomAccessStore p, File dir) {
            this.parent = p;
            this.peekonly = true;
            this.directory = dir;
            this.filelist = dir.list(p.getFilenameFilter());
            if (this.filelist == null) {
                this.filelist = new String[0];
            }
        }

        private boolean more() {
            if (this.itr != null) {
                return this.itr.hasNext();
            }
            return this.index < this.filelist.length && this.obj == null;
        }

        @Override
        public boolean hasMoreElements() {
            this.obj = null;
            if (this.itr == null && this.index >= this.filelist.length) {
                return false;
            }
            while (this.obj == null && this.more()) {
                File file = null;
                if (this.itr != null) {
                    file = (File)this.itr.next();
                } else {
                    try {
                        int num = Integer.parseInt(this.filelist[this.index]);
                        this.parent.addFileNum(num);
                    }
                    catch (NumberFormatException e) {
                        File badfile = new File(this.directory, this.filelist[this.index]);
                        this.logger.log(16, "B2019", badfile.getAbsolutePath());
                        if (!badfile.delete()) {
                            this.logger.log(16, "B1044", badfile.getAbsolutePath());
                        }
                        ++this.index;
                        continue;
                    }
                    file = new File(this.directory, this.filelist[this.index]);
                    ++this.index;
                }
                RandomAccessFile rfile = null;
                try {
                    if (file.length() == 0L) {
                        this.parent.filePool.putFile(file, false);
                        continue;
                    }
                    rfile = new RandomAccessFile(file, "rw");
                    String value = rfile.readUTF();
                    if (RandomAccessStore.GOOD.equals(value)) {
                        long length = rfile.readLong();
                        if (this.peekonly) {
                            this.obj = length;
                            rfile.close();
                            if (this.itr != null) continue;
                            this.parent.addDataFile(file);
                            continue;
                        }
                        byte[] data = new byte[(int)length];
                        rfile.read(data);
                        long endofdata = rfile.getFilePointer();
                        length = rfile.readLong();
                        byte[] attachment = null;
                        if (length > 0L) {
                            attachment = new byte[(int)length];
                            rfile.readFully(attachment);
                        }
                        long endoffile = endofdata + 8L + length;
                        this.obj = this.parent.parseData(data, attachment);
                        this.parent.addRAFile(this.obj, rfile, file, endofdata, endoffile);
                        continue;
                    }
                    if (!RandomAccessStore.FREE_FILE.equals(value) && Store.getDEBUG()) {
                        this.logger.log(4, file + " was corrupted");
                    }
                    if (this.itr != null) continue;
                    this.parent.addFreeRAFile(rfile, file);
                }
                catch (IOException e) {
                    this.logger.log(16, "B2020", (Object)file, (Throwable)e);
                    if (this.itr != null) continue;
                    this.parent.addFreeRAFile(rfile, file);
                }
            }
            return this.obj != null;
        }

        public Object nextElement() {
            if (this.obj != null) {
                Object result = this.obj;
                this.obj = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

