/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

class DestinationListStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();
    static final String DEST_FILE_SIZE_PROP = "imq.persist.file.destination.file.size";
    static final long DEFAULT_DEST_FILE_SIZE = 1024L;
    static final String BASENAME = "destination";
    private PHashMap dstMap = null;
    private File backingFile = null;
    private FileStore parent = null;
    private LoadException loadException = null;

    DestinationListStore(FileStore p, File topDir, boolean clear) throws BrokerException {
        this.parent = p;
        SizeString filesize = this.config.getSizeProperty(DEST_FILE_SIZE_PROP, 1024L);
        if (clear && Store.getDEBUG()) {
            this.logger.log(1, "DestinationList initialized with clear option");
        }
        this.backingFile = new File(topDir, BASENAME);
        try {
            this.dstMap = new PHashMap(this.backingFile, filesize.getBytes(), false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4031", e);
            throw new BrokerException(this.br.getString("B4031"), e);
        }
        try {
            this.dstMap.load(this.parent);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4031", e);
            throw new BrokerException(this.br.getString("B4031"), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4194", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = this.dstMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of destination data", w);
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "DestinationList: loaded " + this.dstMap.size() + " destinations");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    DestinationListStore(FileStore p, File topDir, File oldTopDir) throws BrokerException {
        this.parent = p;
        File oldFile = new File(oldTopDir, BASENAME);
        PHashMap olddata = null;
        this.backingFile = new File(topDir, BASENAME);
        try {
            olddata = new PHashMap(oldFile, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4158", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4158", oldFile, this.backingFile), e);
        }
        try {
            olddata.load(this.parent);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4158", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4158", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4199", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = olddata.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of destination data in old store", w);
        }
        try {
            this.dstMap = new PHashMap(this.backingFile, oldFile.length(), false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4158", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4158", oldFile, this.backingFile), e);
        }
        try {
            this.dstMap.load(this.parent);
        }
        catch (PHashMapLoadException | IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4158", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4158", oldFile, this.backingFile), e);
        }
        w = this.dstMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of destination data", w);
        }
        Iterator itr = olddata.values().iterator();
        Destination dst = null;
        while (itr.hasNext()) {
            dst = (Destination)itr.next();
            this.dstMap.put(dst.getDestinationUID().toString(), dst);
        }
        olddata.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "DestinationList: upgraded " + this.dstMap.size() + " destinations");
        }
        if (this.parent.upgradeNoBackup() && !oldFile.delete()) {
            this.logger.log(32, "B1044", oldFile);
        }
    }

    void syncDestination(Destination destination) throws BrokerException {
        String dstname;
        String string = dstname = destination != null ? destination.getDestinationUID().toString() : null;
        if (dstname != null) {
            this.checkDestination(dstname);
        }
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "DestinationList sync() " + dstname;
                this.logger.log(4, msg);
            }
            this.dstMap.force(dstname);
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, e);
        }
    }

    void storeDestination(Destination destination, boolean sync) throws IOException, BrokerException {
        String dstname = destination.getDestinationUID().toString();
        try {
            Object oldValue = this.dstMap.putIfAbsent(dstname, destination);
            if (oldValue != null) {
                this.logger.log(32, "B3012", destination.getName());
                throw new BrokerException(this.br.getString("B3012", destination.getName()));
            }
            if (sync) {
                this.sync();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4014", destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), e);
        }
    }

    void updateDestination(Destination destination, boolean sync) throws BrokerException {
        String dstname = destination.getDestinationUID().toString();
        this.checkDestination(dstname);
        try {
            this.dstMap.put(dstname, destination);
            if (sync) {
                this.sync();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4014", dstname);
            throw new BrokerException(this.br.getString("B4014", dstname), e);
        }
    }

    void removeDestination(Destination destination, boolean sync) throws BrokerException {
        String dstname = destination.getDestinationUID().toString();
        try {
            Object olddst = this.dstMap.remove(dstname);
            if (olddst == null) {
                this.logger.log(32, "B3013", destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
            if (sync) {
                this.sync();
            }
            this.parent.getMsgStore().releaseMessageDir(destination.getDestinationUID(), sync);
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4144", (Object)destination.getName(), (Throwable)e);
            throw new BrokerException(this.br.getString("B4144", destination.getName()), e);
        }
        catch (IOException e) {
            this.logger.log(32, "B4144", (Object)dstname, (Throwable)e);
            throw new BrokerException(this.br.getString("B4144", dstname), e);
        }
    }

    Destination getDestination(DestinationUID did) throws IOException {
        return (Destination)this.dstMap.get(did.toString());
    }

    Destination[] getAllDestinations() throws IOException {
        return this.dstMap.values().toArray(new Destination[0]);
    }

    Collection getDestinations() {
        return this.dstMap.values();
    }

    void clearAll(boolean sync, boolean clearMessages) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationList.clearAll(" + clearMessages + ") called");
        }
        if (clearMessages) {
            for (Destination dst : this.dstMap.values()) {
                DestinationUID dstuid = dst.getDestinationUID();
                try {
                    this.parent.getMsgStore().releaseMessageDir(dstuid, sync);
                }
                catch (BrokerException | IOException e) {
                    this.logger.log(32, "B4146", this.parent.getMsgStore().getDirName(dstuid), dstuid, e);
                }
            }
        }
        this.dstMap.clear();
        if (sync) {
            try {
                this.sync();
            }
            catch (BrokerException e) {
                this.logger.log(32, "Got exception while synchronizing data to disk", e);
            }
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Destinations", String.valueOf(this.dstMap.size()));
        return t;
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationList: closing, " + this.dstMap.size() + " persisted destinations");
        }
        this.dstMap.close();
    }

    public void dumpDestination() {
        Iterator itr = this.dstMap.values().iterator();
        int count = 0;
        while (itr.hasNext()) {
            System.out.println("dst " + count++ + ":" + itr.next());
        }
    }

    void checkDestination(String dstname) throws BrokerException {
        if (!this.dstMap.containsKey(dstname)) {
            this.logger.log(32, "B3013", dstname);
            throw new BrokerException(this.br.getString("B3013", dstname));
        }
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "DestinationList sync() all";
                this.logger.log(4, msg);
            }
            this.dstMap.force();
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, e);
        }
    }
}

