/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Hashtable;

public class UpdateServiceHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateServiceHandler.getDEBUG();

    public UpdateServiceHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        ServiceInfo info = (ServiceInfo)this.getBodyObject(cmd_msg);
        int status = 200;
        String errMsg = null;
        ServiceManager sm = Globals.getServiceManager();
        Service svc = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else if (info.name == null || (svc = sm.getService(info.name)) == null) {
            status = 500;
            errMsg = this.rb.getString("B4057", info.name == null ? "<null>" : info.name);
        }
        if (status == 200) {
            if (!(svc instanceof IMQService)) {
                status = 500;
                errMsg = "Internal Error: can updated non-standard Service";
            } else {
                try {
                    IMQService stsvc = (IMQService)svc;
                    int port = -1;
                    int min = -1;
                    int max = -1;
                    if (info.isModified(1)) {
                        port = info.port;
                    }
                    if (info.isModified(2)) {
                        min = info.minThreads;
                    }
                    if (info.isModified(4)) {
                        max = info.maxThreads;
                    }
                    if (port != -1 || min != -1 || max != -1) {
                        stsvc.updateService(port, min, max);
                    } else {
                        status = 500;
                        errMsg = this.rb.getString("B4085", info.name);
                    }
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "B2047", svc.getName(), (Throwable)ex);
                    status = 500;
                    errMsg = UpdateServiceHandler.getMessageFromException(ex);
                }
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        UpdateServiceHandler.setProperties(reply, 47, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

