/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class TxnConverter {
    TransactionList transactionList;
    TxnLoggingStore store;
    static Logger logger = Globals.getLogger();
    DestinationList DL = Globals.getDestinationList();

    TxnConverter(TransactionList transactionList, TxnLoggingStore store) {
        this.transactionList = transactionList;
        this.store = store;
    }

    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.TxnConverter.";
    }

    void getSentMessages(TransactionInformation txnInfo, TransactionWork txnWork) throws BrokerException {
        List sentMessageIds = txnInfo.getPublishedMessages();
        for (SysMessageID mid : sentMessageIds) {
            PacketReference packRef = DestinationList.get((PartitionedStore)((Object)this.store), mid);
            if (packRef == null) {
                String msg = this.getPrefix() + " convertLocalToTxnLogFormat: can not find packet for sent msg " + mid + " in txn " + txnInfo;
                logger.log(16, msg);
                continue;
            }
            DestinationUID destUID = packRef.getDestination().getDestinationUID();
            ConsumerUID[] interests = ((PartitionedStore)((Object)this.store)).getConsumerUIDs(destUID, mid);
            TransactionWorkMessage twm = new TransactionWorkMessage();
            twm.setStoredInterests(interests);
            twm.setPacketReference(packRef);
            twm.setDestUID(destUID);
            txnWork.addMessage(twm);
        }
    }

    void getConsumedMessages(TransactionInformation txnInfo, TransactionWork txnWork) throws BrokerException {
        LinkedHashMap cm = txnInfo.getConsumedMessages(false);
        Iterator iter = cm.entrySet().iterator();
        HashMap cuidToStored = this.transactionList.retrieveStoredConsumerUIDs(txnInfo.tid);
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            SysMessageID mid = (SysMessageID)entry.getKey();
            List consumers = (List)entry.getValue();
            PacketReference packRef = DestinationList.get((PartitionedStore)((Object)this.store), mid);
            if (packRef == null) {
                String msg = this.getPrefix() + " convertLocalToTxnLogFormat: can not find packet for consumed msg" + mid + " in txn " + txnInfo;
                logger.log(16, msg);
                continue;
            }
            DestinationUID destUID = packRef.getDestination().getDestinationUID();
            if (consumers == null) continue;
            for (int i = 0; i < consumers.size(); ++i) {
                ConsumerUID cid = (ConsumerUID)consumers.get(i);
                ConsumerUID storedcid = (ConsumerUID)cuidToStored.get(cid);
                if (storedcid == null) {
                    if (ToTxnLogConverter.DEBUG) {
                        String msg = this.getPrefix() + " storedcid=null for " + cid;
                        logger.log(4, msg);
                    }
                    storedcid = cid;
                }
                TransactionWorkMessageAck twma = new TransactionWorkMessageAck(destUID, mid, storedcid);
                if (ToTxnLogConverter.DEBUG) {
                    String msg = this.getPrefix() + " convertLocalToTxnLogFormat: converting messageAck: mid=" + mid + " destID=" + destUID + " consumerID=" + cid + " storedCid=" + storedcid + " txid=" + txnInfo.tid;
                    logger.log(4, msg);
                }
                txnWork.addMessageAcknowledgement(twma);
            }
        }
    }

    void deleteSentMessagesFromStore(TransactionWork txnWork) throws BrokerException {
        for (TransactionWorkMessage twm : txnWork.getSentMessages()) {
            DestinationUID duid = twm.getDestUID();
            SysMessageID mid = twm.getMessage().getSysMessageID();
            try {
                ((PartitionedStore)((Object)this.store)).removeMessage(duid, mid, true);
            }
            catch (IOException e) {
                String msg = "Could not remove transacted sent message during txn conversion";
                logger.logStack(32, msg, e);
            }
        }
    }
}

