/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.conversion;

import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.JavaStringConverter;

public class JavaIDValueConverter
extends IDValueConverter {
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.charAt(0) == '^') {
                string = string.substring(1);
            }
            String result = JavaIDValueConverter.convertFromJavaIdentifier(string, node);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected void assertValidValue(String value) {
        super.assertValidValue(value);
        if (!JavaIDValueConverter.isValidIdentifierStart(value.charAt(0))) {
            throw new ValueConverterException(value + " is not a valid identifier.", null, null);
        }
        int i = 1;
        int length = value.length();
        while (i < length) {
            if (!JavaIDValueConverter.isValidIdentifierPart(value.charAt(i))) {
                throw new ValueConverterException(value + " is not a valid identifier.", null, null);
            }
            ++i;
        }
    }

    protected void assertTokens(String value, String result) {
    }

    protected TokenSource getTokenSource(String escapedValue) {
        throw new UnsupportedOperationException();
    }

    public static boolean isValidIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isValidIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static String convertFromJavaIdentifier(String identifier, INode node) {
        int idx = identifier.indexOf(92);
        if (idx < 0) {
            return identifier;
        }
        Implementation converter = new Implementation();
        String result = converter.convertFromJavaString(identifier, idx);
        if (converter.error) {
            throw new ValueConverterWithValueException("Illegal escape sequence in identifier '" + identifier + "'", node, (Object)result, null);
        }
        if (converter.badChar) {
            if (result.length() != 0) {
                throw new ValueConverterWithValueException("Illegal character in identifier '" + result + "' (" + identifier + ")", node, (Object)result, null);
            }
            throw new ValueConverterWithValueException("Illegal character in identifier '" + identifier + "'", node, null, null);
        }
        return result;
    }

    protected static class Implementation
    extends JavaStringConverter {
        boolean error = false;
        boolean badChar = false;

        protected Implementation() {
        }

        public String convertFromJavaString(String identifier, int firstEscapeSequence) throws ValueConverterException {
            StringBuilder result = new StringBuilder(identifier.length());
            result.append(identifier, 0, firstEscapeSequence);
            return this.convertFromJavaString(identifier, true, firstEscapeSequence, result);
        }

        protected int handleInvalidUnicodeEscapeSequence(String string, int index, StringBuilder result) {
            result.append('u');
            this.error = true;
            return index;
        }

        protected int doUnescapeCharAndAppendTo(String string, boolean useUnicode, int index, StringBuilder result) {
            if (string.length() == index) {
                this.badChar = true;
                return index;
            }
            return super.doUnescapeCharAndAppendTo(string, useUnicode, index, result);
        }

        protected int handleUnknownEscapeSequence(String string, char c, boolean useUnicode, int index, StringBuilder result) {
            this.badChar = true;
            return index;
        }

        protected boolean validate(char c, StringBuilder result) {
            if (result.length() == 0) {
                if (!JavaIDValueConverter.isValidIdentifierStart(c)) {
                    this.badChar = true;
                    return false;
                }
            } else if (!JavaIDValueConverter.isValidIdentifierPart(c)) {
                this.badChar = true;
                return false;
            }
            return super.validate(c, result);
        }
    }
}

