/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeableManifest
extends Manifest {
    public static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-Name");
    public static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    public static final Attributes.Name BUNDLE_CLASSPATH = new Attributes.Name("Bundle-ClassPath");
    public static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    public static final Attributes.Name BUNDLE_REQUIRED_EXECUTION_ENV = new Attributes.Name("Bundle-RequiredExecutionEnvironment");
    public static final Attributes.Name EXPORT_PACKAGE = new Attributes.Name("Export-Package");
    public static final Attributes.Name IMPORT_PACKAGE = new Attributes.Name("Import-Package");
    public static final Attributes.Name REQUIRE_BUNDLE = new Attributes.Name("Require-Bundle");
    public static final Attributes.Name BUNDLE_ACTIVATION_POLICY = new Attributes.Name("Bundle-ActivationPolicy");
    public static final Attributes.Name BUNDLE_LOCALIZATION = new Attributes.Name("Bundle-Localization");
    public static final Attributes.Name BUNDLE_ACTIVATOR = new Attributes.Name("Bundle-Activator");
    private static final String LINEBREAK = "\r\n";
    private boolean modified = false;
    private String projectName;

    static String make512Safe(StringBuffer lines) {
        if (lines.length() > 512) {
            String[] splitted;
            StringBuilder result = new StringBuilder(lines.length());
            String[] stringArray = splitted = lines.toString().split("\\r\\n");
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.length() > 512) {
                    int idx = 510;
                    StringBuilder temp = new StringBuilder(string);
                    int length = temp.length();
                    while (idx < length - 2) {
                        temp.insert(idx, "\r\n ");
                        idx += 512;
                        length += 3;
                    }
                    result.append(temp.toString());
                } else {
                    result.append(string);
                }
                result.append(LINEBREAK);
                ++n2;
            }
            return result.toString();
        }
        return lines.toString();
    }

    public MergeableManifest(InputStream in) throws IOException {
        try {
            Field field = Manifest.class.getDeclaredField("attr");
            field.setAccessible(true);
            field.set(this, new OrderAwareAttributes());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.read(in);
        this.addRequiredBundles(Collections.<String>emptySet());
        this.addExportedPackages(Collections.<String>emptySet());
        this.modified = false;
    }

    public MergeableManifest(InputStream in, String projectName) throws IOException {
        this(in);
        this.projectName = projectName;
    }

    public void addRequiredBundles(Set<String> bundles) {
        Set<String> bundlesToMerge;
        String bundleName = (String)this.getMainAttributes().get(BUNDLE_NAME);
        if (bundleName != null && bundles.contains(bundleName) || this.projectName != null && bundles.contains(this.projectName)) {
            bundlesToMerge = new LinkedHashSet<String>(bundles);
            bundlesToMerge.remove(bundleName);
            bundlesToMerge.remove(this.projectName);
        } else {
            bundlesToMerge = bundles;
        }
        String s = (String)this.getMainAttributes().get(REQUIRE_BUNDLE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, bundlesToMerge, modified);
        this.modified = modified.get();
        this.getMainAttributes().put(REQUIRE_BUNDLE, result);
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        ((OrderAwareAttributes)this.getMainAttributes()).myWriteMain(dos);
        for (Map.Entry<String, Attributes> e : this.getEntries().entrySet()) {
            StringBuffer buffer = new StringBuffer("Name: ");
            String value = e.getKey();
            if (value != null) {
                byte[] vb = value.getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
            }
            buffer.append(value);
            buffer.append(LINEBREAK);
            dos.writeBytes(MergeableManifest.make512Safe(buffer));
            ((OrderAwareAttributes)e.getValue()).myWrite(dos);
        }
        dos.flush();
    }

    public void addExportedPackages(Set<String> packages) {
        String s = (String)this.getMainAttributes().get(EXPORT_PACKAGE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, packages, modified);
        this.modified = modified.get();
        this.getMainAttributes().put(EXPORT_PACKAGE, result);
    }

    public void addImportedPackages(Set<String> packages) {
        String s = (String)this.getMainAttributes().get(IMPORT_PACKAGE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, packages, modified);
        this.modified = modified.get();
        this.getMainAttributes().put(IMPORT_PACKAGE, result);
    }

    protected static String[] splitQuoteAware(String string) {
        ArrayList result = Lists.newArrayList((Object[])new StringBuilder[]{new StringBuilder()});
        boolean inQuote = false;
        int i = 0;
        while (i < string.length()) {
            switch (string.charAt(i)) {
                case ',': {
                    if (inQuote) {
                        ((StringBuilder)result.get(result.size() - 1)).append(string.charAt(i));
                        break;
                    }
                    result.add(new StringBuilder());
                    break;
                }
                case '\"': {
                    inQuote = !inQuote;
                }
                default: {
                    ((StringBuilder)result.get(result.size() - 1)).append(string.charAt(i));
                }
            }
            ++i;
        }
        String[] resultArray = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            resultArray[i2] = ((StringBuilder)result.get(i2)).toString();
            ++i2;
        }
        return resultArray;
    }

    public static String mergeIntoCommaSeparatedList(String currentString, Set<String> toMergeIn, Wrapper<Boolean> modified) {
        String string = currentString == null ? "" : currentString;
        String[] split = MergeableManifest.splitQuoteAware(string);
        LinkedHashSet<ParameterizedElement> all = new LinkedHashSet<ParameterizedElement>();
        int i = 0;
        while (i < split.length) {
            String value = split[i];
            if (!value.trim().equals("")) {
                all.add(new ParameterizedElement(value.trim()));
            }
            ++i;
        }
        for (String value : toMergeIn) {
            if (value.trim().equals("")) continue;
            if (value.indexOf(59) != -1) {
                throw new IllegalArgumentException("Element " + value + " contains a semicolon. Merging parameterized elements is not yet supported");
            }
            modified.set(all.add(new ParameterizedElement(value.trim())) || modified.get() != false);
        }
        StringBuffer buff = new StringBuffer(string.length());
        Iterator iterator = all.iterator();
        while (iterator.hasNext()) {
            String s = ((ParameterizedElement)iterator.next()).toString();
            buff.append(s);
            if (!iterator.hasNext()) continue;
            buff.append(",\r\n ");
        }
        String result = buff.toString();
        return result;
    }

    public class OrderAwareAttributes
    extends Attributes {
        public OrderAwareAttributes() {
            try {
                Field field = Attributes.class.getDeclaredField("map");
                field.setAccessible(true);
                field.set(this, new LinkedHashMap());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public Object put(Object name, Object value) {
            Object result = super.put(name, value);
            if (result != null && !result.equals(value)) {
                MergeableManifest.this.modified = true;
            }
            return result;
        }

        public void myWriteMain(DataOutputStream out) throws IOException {
            String vername = Attributes.Name.MANIFEST_VERSION.toString();
            String version = this.getValue(vername);
            if (version == null) {
                vername = Attributes.Name.SIGNATURE_VERSION.toString();
                version = this.getValue(vername);
            }
            if (version != null) {
                out.writeBytes(String.valueOf(vername) + ": " + version + MergeableManifest.LINEBREAK);
            }
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> e = it.next();
                String value = (String)e.getValue();
                if (Strings.isEmpty(value)) continue;
                String name = ((Attributes.Name)e.getKey()).toString();
                if (version == null || name.equalsIgnoreCase(vername)) continue;
                StringBuffer buffer = new StringBuffer(name);
                buffer.append(": ");
                byte[] vb = value.trim().getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
                buffer.append(value);
                if (it.hasNext()) {
                    buffer.append(MergeableManifest.LINEBREAK);
                }
                out.writeBytes(MergeableManifest.make512Safe(buffer));
            }
            out.writeBytes(MergeableManifest.LINEBREAK);
        }

        public void myWrite(DataOutputStream out) throws IOException {
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> e = it.next();
                String value = (String)e.getValue();
                if (!Strings.isEmpty(value)) continue;
                StringBuffer buffer = new StringBuffer(((Attributes.Name)e.getKey()).toString());
                buffer.append(": ");
                byte[] vb = value.trim().getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
                buffer.append(value);
                if (it.hasNext()) {
                    buffer.append(MergeableManifest.LINEBREAK);
                }
                out.writeBytes(MergeableManifest.make512Safe(buffer));
            }
            out.writeBytes(MergeableManifest.LINEBREAK);
        }
    }

    public static class ParameterizedElement {
        private final String name;
        private final String value;

        public ParameterizedElement(String value) {
            this.value = value;
            this.name = value.indexOf(59) == -1 ? value : value.substring(0, value.indexOf(59));
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            ParameterizedElement other = (ParameterizedElement)obj;
            return this.name.equals(other.name);
        }
    }
}

