/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionManager;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.IResourceScopeCache;

public class DerivedStateAwareResourceDescriptionManager
extends DefaultResourceDescriptionManager {
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;

    protected IResourceDescription internalGetResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        DerivedStateAwareResource res = (DerivedStateAwareResource)resource;
        boolean isInitialized = res.fullyInitialized || res.isInitializing;
        try {
            if (!isInitialized) {
                res.eSetDeliver(false);
                res.installDerivedState(true);
            }
            IResourceDescription description = this.createResourceDescription(resource, strategy);
            if (!isInitialized) {
                Lists.newArrayList(description.getExportedObjects());
            }
            IResourceDescription iResourceDescription = description;
            return iResourceDescription;
        }
        finally {
            if (!isInitialized) {
                res.discardDerivedState();
                res.eSetDeliver(true);
            }
        }
    }

    protected IResourceDescription createResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        return new DefaultResourceDescription(resource, strategy, this.cache){

            protected EObjectDescriptionLookUp getLookUp() {
                if (this.lookup == null) {
                    this.lookup = new EObjectDescriptionLookUp(this.computeExportedObjects());
                }
                return this.lookup;
            }
        };
    }
}

