/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

public class GeneratorComponent
implements IWorkflowComponent {
    private Injector injector;
    private List<String> slotNames = Lists.newArrayList();
    private Map<String, String> outlets = Maps.newHashMap();

    public void setRegister(ISetup setup) {
        this.injector = setup.createInjectorAndDoEMFRegistration();
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void addSlot(String slot) {
        this.slotNames.add(slot);
    }

    public void preInvoke() {
        if (this.slotNames.isEmpty()) {
            throw new IllegalStateException("no 'slot' has been configured.");
        }
        if (this.injector == null) {
            throw new IllegalStateException("no Injector has been configured. Use 'register' with an ISetup or 'injector' directly.");
        }
        if (this.outlets.isEmpty()) {
            throw new IllegalStateException("no 'outlet' has been configured.");
        }
        for (Map.Entry<String, String> outlet : this.outlets.entrySet()) {
            if (outlet.getKey() == null) {
                throw new IllegalStateException("One of the outlets was configured without a name");
            }
            if (outlet.getValue() != null) continue;
            throw new IllegalStateException("The path of outle '" + outlet.getKey() + "' was null.");
        }
    }

    public void addOutlet(Outlet out) {
        this.outlets.put(out.outletName, out.path);
    }

    public void invoke(IWorkflowContext ctx) {
        IGenerator instance = this.getCompiler();
        IFileSystemAccess fileSystemAccess = this.getConfiguredFileSystemAccess();
        for (String slot : this.slotNames) {
            Object object = ctx.get(slot);
            if (object == null) {
                throw new IllegalStateException("Slot '" + slot + "' was empty!");
            }
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                for (Object object2 : iterable) {
                    if (!(object2 instanceof Resource)) {
                        throw new IllegalStateException("Slot contents was not a Resource but a '" + object.getClass().getSimpleName() + "'!");
                    }
                    instance.doGenerate((Resource)object2, fileSystemAccess);
                }
                continue;
            }
            if (object instanceof Resource) {
                instance.doGenerate((Resource)object, fileSystemAccess);
                continue;
            }
            throw new IllegalStateException("Slot contents was not a Resource but a '" + object.getClass().getSimpleName() + "'!");
        }
    }

    protected IGenerator getCompiler() {
        return (IGenerator)this.injector.getInstance(IGenerator.class);
    }

    protected IFileSystemAccess getConfiguredFileSystemAccess() {
        JavaIoFileSystemAccess configuredFileSystemAccess = (JavaIoFileSystemAccess)this.injector.getInstance(JavaIoFileSystemAccess.class);
        for (Map.Entry<String, String> outs : this.outlets.entrySet()) {
            configuredFileSystemAccess.setOutputPath(outs.getKey(), outs.getValue());
        }
        return configuredFileSystemAccess;
    }

    public void postInvoke() {
    }

    public static class Outlet {
        private String outletName = "DEFAULT_OUTPUT";
        private String path;

        public void setOutletName(String outputName) {
            this.outletName = outputName;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getOutletName() {
            return this.outletName;
        }

        public String getPath() {
            return this.path;
        }
    }
}

