/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.xtend2.Xtend2RuntimeModule;
import org.eclipse.xtext.xtend2.ui.Xtend2UiModule;
import org.osgi.framework.BundleContext;

public class Xtend2Activator
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(Xtend2Activator.class);
    private Cache<String, Injector> injectors = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Injector>(){

        public Injector load(String language) throws Exception {
            Module runtimeModule = Xtend2Activator.this.getRuntimeModule(language);
            Module sharedStateModule = Xtend2Activator.this.getSharedStateModule();
            Module uiModule = Xtend2Activator.this.getUiModule(language);
            Module mergedModule = Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{runtimeModule}).with(new Module[]{sharedStateModule})}).with(new Module[]{uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
    });
    private static Xtend2Activator INSTANCE;
    public static final String ORG_ECLIPSE_XTEXT_XTEND2_XTEND2 = "org.eclipse.xtext.xtend2.Xtend2";

    public Injector getInjector(String languageName) {
        try {
            return (Injector)this.injectors.get((Object)languageName);
        }
        catch (ExecutionException e) {
            logger.error((Object)("Failed to create injector for " + languageName));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to create injector for " + languageName, e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.injectors.invalidateAll();
        this.injectors.cleanUp();
        INSTANCE = null;
        super.stop(context);
    }

    public static Xtend2Activator getInstance() {
        return INSTANCE;
    }

    protected Module getRuntimeModule(String grammar) {
        if (ORG_ECLIPSE_XTEXT_XTEND2_XTEND2.equals(grammar)) {
            return new Xtend2RuntimeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if (ORG_ECLIPSE_XTEXT_XTEND2_XTEND2.equals(grammar)) {
            return new Xtend2UiModule(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

