/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResult;

public class ReferenceQuery
implements ISearchQuery {
    @Inject
    private IResourceDescriptions resourceDescriptions;
    private ReferenceSearchResult searchResult = new ReferenceSearchResult(this);
    private URI eObjectTargetURI;
    private String label;

    public void init(URI eObjectTargetURI, String label) {
        this.eObjectTargetURI = eObjectTargetURI;
        this.label = label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.reset();
        int numResources = Iterables.size((Iterable)this.resourceDescriptions.getAllResourceDescriptions());
        monitor.beginTask(Messages.ReferenceQuery_monitor, numResources);
        for (IResourceDescription resourceDescription : this.resourceDescriptions.getAllResourceDescriptions()) {
            Iterable matchingReferenceDescriptors = Iterables.filter((Iterable)resourceDescription.getReferenceDescriptions(), (Predicate)new Predicate<IReferenceDescription>(){

                public boolean apply(IReferenceDescription input) {
                    return ReferenceQuery.this.eObjectTargetURI.equals((Object)input.getTargetEObjectUri());
                }
            });
            for (IReferenceDescription matchingReferenceDescription : matchingReferenceDescriptors) {
                this.searchResult.addMatchingReference(matchingReferenceDescription);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }
}

