/*******************************************************************************
 * Copyright (c) 2010 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtext.example.arithmetics.ui.contentassist;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.example.arithmetics.ui.contentassist.AbstractArithmeticsProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * @author Sven Efftinge - initial contribution and API
 *
 */
public class ArithmeticsProposalProvider extends AbstractArithmeticsProposalProvider {
	
	
	/**
	 * sets the selection on the arguments for proposed functions.
	 */
	@Override
	public void completePrimaryExpression_Func(EObject model,
			Assignment assignment, ContentAssistContext context,
			final ICompletionProposalAcceptor acceptor) {
		super.completePrimaryExpression_Func(model, assignment, context, new ICompletionProposalAcceptor() {

			public void accept(ICompletionProposal proposal) {
				if (proposal instanceof ConfigurableCompletionProposal) {
					ConfigurableCompletionProposal ccp = (ConfigurableCompletionProposal) proposal;
					String string = ccp.getReplacementString();
					int indexOfOpenPar = string.indexOf('(');
					if (indexOfOpenPar!=-1) {
						int oldSelectionStart = ccp.getSelectionStart();
						ccp.setSelectionStart(oldSelectionStart-string.length()+indexOfOpenPar+1);
						ccp.setSelectionLength(oldSelectionStart-ccp.getSelectionStart()-1);
					}
				}
				acceptor.accept(proposal);
			}

			public boolean canAcceptMoreProposals() {
				return acceptor.canAcceptMoreProposals();
			}
			
		});
	}
}
