/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.xtext.ui.editor.outline.XtextContentOutlinePage;
import org.eclipse.xtext.ui.editor.outline.linking.ToggleHelper;

public abstract class AbstractOutlineAction
extends Action {
    private final XtextContentOutlinePage outlinePage;

    public AbstractOutlineAction(String text, XtextContentOutlinePage outlinePage) {
        super(text);
        this.outlinePage = outlinePage;
        boolean checked = ToggleHelper.isToggleEnabled(this.getToggleId());
        this.valueChanged(checked, false);
    }

    protected abstract String getToggleId();

    protected XtextContentOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public final void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean checkedState, boolean store) {
        this.setChecked(checkedState);
        this.performAction(checkedState);
        if (store) {
            ToggleHelper.setToggleEnabled(this.getToggleId(), checkedState);
        }
    }

    protected abstract void performAction(boolean var1);
}

