/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.ui.editor.AbstractDamagerRepairer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastDamagerRepairer
extends AbstractDamagerRepairer {
    private boolean checkInvariant = false;
    private List<TokenInfo> tokenInfos;
    private IRegion previousRegion;
    private DocumentEvent previousEvent;
    private final Provider<Lexer> lexer;

    @Inject
    public FastDamagerRepairer(ITokenScanner scanner, @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING") Provider<Lexer> lexer) {
        super(scanner);
        this.lexer = lexer;
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        this.tokenInfos = this.createTokenInfos(document.get());
    }

    private List<TokenInfo> createTokenInfos(String string) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(string.length() / 3));
        Lexer source = this.createLexer(string);
        CommonToken token = (CommonToken)source.nextToken();
        while (token != Token.EOF_TOKEN) {
            TokenInfo info = this.createTokenInfo(token);
            result.add(info);
            token = (CommonToken)source.nextToken();
        }
        return result;
    }

    protected TokenInfo createTokenInfo(CommonToken token) {
        TokenInfo info = new TokenInfo(token);
        return info;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        if (documentPartitioningChanged) {
            this.previousEvent = null;
            this.previousRegion = null;
            this.tokenInfos = Lists.newArrayList();
            return partition;
        }
        if (this.previousEvent == e && this.previousRegion != null) {
            if (this.isCheckInvariant()) {
                this.doCheckInvariant(e);
            }
            return this.previousRegion;
        }
        this.previousEvent = e;
        this.previousRegion = this.computeDamageRegion(e);
        if (this.isCheckInvariant()) {
            this.doCheckInvariant(e);
        }
        return this.previousRegion;
    }

    protected void doCheckInvariant(DocumentEvent e) {
        List<TokenInfo> parsedTokenInfos = this.createTokenInfos(e.fDocument.get());
        if (!parsedTokenInfos.equals(this.tokenInfos)) {
            throw new IllegalStateException("Expected: '" + parsedTokenInfos + "' but was: '" + this.tokenInfos + "'.");
        }
    }

    private IRegion computeDamageRegion(DocumentEvent e) {
        if (e.getDocument().getLength() == 0) {
            this.tokenInfos = this.createTokenInfos(e.fDocument.get());
            return new Region(0, 0);
        }
        if (this.tokenInfos.isEmpty()) {
            this.tokenInfos = this.createTokenInfos(e.fDocument.get());
            return new Region(0, e.getDocument().getLength());
        }
        int tokenStartsAt = 0;
        int tokenInfoIdx = 0;
        int regionOffset = 0;
        int regionLength = e.fDocument.getLength();
        Lexer source = this.createLexer(e.fDocument.get());
        CommonToken token = (CommonToken)source.nextToken();
        while (true) {
            TokenInfo tokenInfo;
            if (token == Token.EOF_TOKEN) {
                this.tokenInfos.subList(tokenInfoIdx, this.tokenInfos.size()).clear();
                break;
            }
            if (tokenInfoIdx >= this.tokenInfos.size() || (tokenInfo = this.tokenInfos.get(tokenInfoIdx)).type != token.getType() || token.getStopIndex() - token.getStartIndex() + 1 != tokenInfo.length || tokenStartsAt + tokenInfo.length > e.fOffset) break;
            tokenStartsAt += tokenInfo.length;
            ++tokenInfoIdx;
            token = (CommonToken)source.nextToken();
        }
        regionLength -= tokenStartsAt;
        regionOffset = tokenStartsAt;
        int lengthDiff = e.fText.length() - e.fLength;
        while (token != Token.EOF_TOKEN && tokenInfoIdx < this.tokenInfos.size()) {
            while (tokenInfoIdx < this.tokenInfos.size()) {
                TokenInfo tokenInfo = this.tokenInfos.get(tokenInfoIdx);
                if (token.getStartIndex() >= e.fOffset + e.fText.length() && tokenStartsAt + lengthDiff == token.getStartIndex() && tokenInfo.type == token.getType() && token.getStopIndex() - token.getStartIndex() + 1 == tokenInfo.length) {
                    return new Region(regionOffset, token.getStartIndex() - regionOffset);
                }
                if (tokenStartsAt + lengthDiff + tokenInfo.length > token.getStopIndex() + 1) break;
                this.tokenInfos.remove(tokenInfoIdx);
                if ((tokenStartsAt += tokenInfo.length) + lengthDiff <= token.getStartIndex()) continue;
            }
            this.tokenInfos.add(tokenInfoIdx++, this.createTokenInfo(token));
            token = (CommonToken)source.nextToken();
        }
        this.tokenInfos.subList(tokenInfoIdx, this.tokenInfos.size()).clear();
        if (tokenInfoIdx >= this.tokenInfos.size()) {
            while (token != Token.EOF_TOKEN) {
                this.tokenInfos.add(this.createTokenInfo(token));
                token = (CommonToken)source.nextToken();
            }
        }
        return new Region(regionOffset, regionLength);
    }

    protected Lexer createLexer(String string) {
        Lexer l = (Lexer)this.lexer.get();
        l.setCharStream((CharStream)new ANTLRStringStream(string));
        return l;
    }

    public void setCheckInvariant(boolean checkInvariant) {
        this.checkInvariant = checkInvariant;
    }

    public boolean isCheckInvariant() {
        return this.checkInvariant;
    }

    private static class TokenInfo {
        private final int length;
        private final int type;

        private TokenInfo(CommonToken token) {
            this.length = token.getStopIndex() - token.getStartIndex() + 1;
            this.type = token.getType();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenInfo other = (TokenInfo)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "TokenInfo [length=" + this.length + ", type=" + this.type + "]";
        }
    }
}

