/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.xtext.ui.AbstractTypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;

public class JdtTypesProposalProvider
extends AbstractTypesProposalProvider {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private IJavaProjectProvider projectProvider;

    public ITypesProposalProvider getScopedProposalProvider(EObject context, IScope scope) {
        return new ScopeAwareProposalProvider(context, scope);
    }

    public void createSubTypeProposals(JvmType superType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        if (superType == null || superType.eIsProxy()) {
            return;
        }
        if (superType.eResource() == null || superType.eResource().getResourceSet() == null) {
            return;
        }
        IJavaProject project = this.getProjectProvider().getJavaProject(superType.eResource().getResourceSet());
        if (project == null) {
            return;
        }
        String fqn = superType.getCanonicalName();
        if (Object.class.getName().equals(fqn)) {
            this.createTypeProposals(project, proposalFactory, context, filter, acceptor);
            return;
        }
        final Collection superTypes = this.superTypeCollector.collectSuperTypeNames(superType);
        try {
            IType type = project.findType(fqn);
            if (type != null) {
                IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
                this.searchAndCreateProposals(scope, proposalFactory, context, TypeMatchFilters.and(filter, new ITypesProposalProvider.Filter(){

                    public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
                        if (packageName.length != 0) {
                            fqName.append(packageName);
                            fqName.append('.');
                        }
                        char[][] cArray = enclosingTypeNames;
                        int n = enclosingTypeNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] enclosingType = cArray[n2];
                            fqName.append(enclosingType);
                            fqName.append('$');
                            ++n2;
                        }
                        fqName.append(simpleTypeName);
                        String fqNameAsString = fqName.toString();
                        return !superTypes.contains(fqNameAsString);
                    }
                }), acceptor);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void searchAndCreateProposals(IJavaSearchScope scope, final ICompletionProposalFactory proposalFactory, final ContentAssistContext context, final ITypesProposalProvider.Filter filter, final ICompletionProposalAcceptor acceptor) throws JavaModelException {
        String prefix = context.getPrefix();
        String[] split = prefix.split("\\.");
        char[] typeName = null;
        char[] packageName = null;
        if (prefix.length() > 0 && split.length > 0) {
            if (Character.isUpperCase(split[split.length - 1].charAt(0))) {
                typeName = split[split.length - 1].toCharArray();
                if (split.length > 1) {
                    packageName = prefix.substring(0, prefix.length() - (typeName.length + 1)).toCharArray();
                }
            } else {
                if (prefix.endsWith(".")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                packageName = prefix.toCharArray();
            }
        }
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames(packageName, 1, typeName, 1, 0, scope, new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (filter.accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path)) {
                    StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
                    if (packageName.length != 0) {
                        fqName.append(packageName);
                        fqName.append('.');
                    }
                    char[][] cArray = enclosingTypeNames;
                    int n = enclosingTypeNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] enclosingType = cArray[n2];
                        fqName.append(enclosingType);
                        fqName.append('$');
                        ++n2;
                    }
                    fqName.append(simpleTypeName);
                    JdtTypesProposalProvider.this.createTypeProposal(fqName.toString(), modifiers, enclosingTypeNames.length > 0, proposalFactory, context, acceptor);
                }
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor(){

            public boolean isCanceled() {
                return !acceptor.canAcceptMoreProposals();
            }
        });
    }

    public void createTypeProposals(ICompletionProposalFactory proposalFactory, ContentAssistContext context, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        this.createTypeProposals(javaProject, proposalFactory, context, filter, acceptor);
    }

    public void createTypeProposals(IJavaProject project, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
            this.searchAndCreateProposals(searchScope, proposalFactory, context, filter, acceptor);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void createTypeProposal(String typeName, int modifiers, boolean isInnerType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (acceptor.canAcceptMoreProposals()) {
            int lastDot = typeName.lastIndexOf(46);
            String displayString = typeName;
            if (lastDot != -1) {
                displayString = String.valueOf(typeName.substring(lastDot + 1)) + " - " + typeName.substring(0, lastDot);
            }
            Image img = this.computeImage(typeName, isInnerType, modifiers);
            ICompletionProposal proposal = proposalFactory.createCompletionProposal(typeName, displayString, img, context);
            acceptor.accept(proposal);
        }
    }

    protected Image computeImage(String typeName, boolean isInnerType, int modifiers) {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaElementImageProvider.getTypeImageDescriptor((boolean)isInnerType, (boolean)false, (int)modifiers, (boolean)false));
    }

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    public SuperTypeCollector getSuperTypeCollector() {
        return this.superTypeCollector;
    }

    public void setProjectProvider(IJavaProjectProvider projectProvider) {
        this.projectProvider = projectProvider;
    }

    public IJavaProjectProvider getProjectProvider() {
        return this.projectProvider;
    }

    public class ScopeAwareProposalProvider
    extends AbstractTypesProposalProvider
    implements ConfigurableCompletionProposal.IReplacementTextApplier {
        private final IScope scope;
        private final EObject context;

        public ScopeAwareProposalProvider(EObject context, IScope scope) {
            this.context = context;
            this.scope = scope;
        }

        public ICompletionProposalAcceptor wrap(ICompletionProposalAcceptor acceptor) {
            ICompletionProposalAcceptor.Delegate result = new ICompletionProposalAcceptor.Delegate(){

                public void accept(ICompletionProposal proposal) {
                    if (proposal instanceof ConfigurableCompletionProposal) {
                        ((ConfigurableCompletionProposal)proposal).setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)ScopeAwareProposalProvider.this);
                    }
                    super.accept(proposal);
                }
            };
            result.setDelegate(acceptor);
            return result;
        }

        public void createTypeProposals(ICompletionProposalFactory proposalFactory, ContentAssistContext context, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
            JdtTypesProposalProvider.this.createTypeProposals(proposalFactory, context, filter, this.wrap(acceptor));
        }

        public void createSubTypeProposals(JvmType superType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
            JdtTypesProposalProvider.this.createSubTypeProposals(superType, proposalFactory, context, filter, this.wrap(acceptor));
        }

        protected String applyValueConverter(String string) {
            return string;
        }

        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
            String replacementString = this.getActualReplacementString(proposal);
            document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
        }

        public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
            IEObjectDescription shortedElement;
            EObject resolved;
            String replacementString = proposal.getReplacementString();
            IEObjectDescription element = this.scope.getContentByName(replacementString);
            if (element != null && !(resolved = EcoreUtil.resolve((EObject)element.getEObjectOrProxy(), (EObject)this.context)).eIsProxy() && (shortedElement = this.scope.getContentByEObject(resolved)) != null) {
                replacementString = this.applyValueConverter(shortedElement.getName());
            }
            return replacementString;
        }
    }
}

