/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.linking;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.outline.XtextContentOutlinePage;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

public class ToggleLinkWithEditorAction
extends Action
implements IPropertyChangeListener,
IPartListener {
    private final XtextContentOutlinePage outlinePage;

    public ToggleLinkWithEditorAction(XtextContentOutlinePage outlinePage) {
        super(XtextUIMessages.ToggleLinkWithEditorAction_label);
        this.outlinePage = outlinePage;
        this.setChecked(this.isLinkingEnabled());
        this.setToolTipText(XtextUIMessages.ToggleLinkWithEditorAction_toolTip);
        this.setDescription(XtextUIMessages.ToggleLinkWithEditorAction_description);
        this.setImageDescriptor(XtextPluginImages.DESC_LINK_WITH_EDITOR);
        this.setDisabledImageDescriptor(XtextPluginImages.DESC_LINK_WITH_EDITOR_DISABLED);
        this.registerPropertyChangeListener();
    }

    protected void registerPropertyChangeListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.outlinePage.getSite().getPage().addPartListener((IPartListener)this);
    }

    protected boolean isLinkingEnabled() {
        return this.outlinePage.isLinkingEnabled();
    }

    protected void setLinkingEnabled(boolean enabled) {
        this.outlinePage.setLinkingEnabled(enabled);
    }

    public void run() {
        this.setLinkingEnabled(this.isChecked());
        if (this.isLinkingEnabled()) {
            this.outlinePage.synchronizeOutlinePage();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("ToggleLinkWithEditorAction.isChecked".equals(event.getProperty())) {
            Boolean checked = (Boolean)event.getNewValue();
            this.setChecked(checked);
            this.setLinkingEnabled(checked);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.outlinePage.getEditor() != null && this.equalsEditorOrOutlinePart(part) && this.isLinkingEnabled()) {
            this.outlinePage.synchronizeOutlinePage();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.equalsEditorOrOutlinePart(part)) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            this.outlinePage.getSite().getPage().removePartListener((IPartListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected boolean equalsEditorOrOutlinePart(IWorkbenchPart part) {
        return this.outlinePage.getEditor() != null && ((Object)((Object)this.outlinePage.getEditor())).equals(part) || this.outlinePage.equals(part.getAdapter(IContentOutlinePage.class));
    }
}

