/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.ui.editor.AbstractDamagerRepairer;
import org.eclipse.xtext.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class XtextDamagerRepairer
extends AbstractDamagerRepairer {
    private static final Logger log = Logger.getLogger(XtextDamagerRepairer.class);
    private final Provider<Lexer> lexer;
    private final WeakHashMap<IDocument, String> previousContent = new WeakHashMap();
    private final SimpleCache<DocumentEvent, IRegion> cache = new SimpleCache((Function)new Function<DocumentEvent, IRegion>(){

        public IRegion apply(DocumentEvent from) {
            return this.computeTextChangeRegion(from);
        }

        private IRegion computeTextChangeRegion(DocumentEvent e) {
            if (e.getDocument().getLength() == 0) {
                return new Region(0, 0);
            }
            String previousText = (String)XtextDamagerRepairer.this.previousContent.get(e.getDocument());
            if (previousText.length() == 0) {
                return new Region(0, e.getDocument().getLength());
            }
            int start = e.getOffset();
            int end = Math.min(e.getDocument().getLength(), e.getOffset() + e.getLength());
            TokenIterator previous = this.iterator(previousText);
            TokenIterator actual = this.iterator(e.getDocument().get());
            while (previous.hasNext() && actual.hasNext() && this.equal((Token)previous.next(), (Token)actual.next())) {
                if (actual.getCurrent().getStopIndex() < start) continue;
                start = actual.getCurrent().getStartIndex();
                break;
            }
            end = Math.max(end, actual.getCurrent().getStopIndex() + 1);
            start = Math.min(start, actual.getCurrent().getStartIndex());
            int lengthDiff = e.getText().length() - e.getLength();
            while (!this.inSync(previous, actual, lengthDiff) || actual.getCurrent().getStopIndex() + 1 < end) {
                if (!actual.hasNext()) {
                    if (this.equal((Token)previous.getCurrent(), (Token)actual.getCurrent())) {
                        return new Region(end, 0);
                    }
                    return new Region(start, actual.getCurrent().getStopIndex() + 1 - start);
                }
                end = Math.max(end, actual.getCurrent().getStopIndex() + 1);
                actual.next();
                while (previous.getCurrent().getStartIndex() + lengthDiff < actual.getCurrent().getStartIndex()) {
                    if (!previous.hasNext()) {
                        return new Region(start, e.getDocument().getLength() - start);
                    }
                    previous.next();
                }
            }
            end = Math.max(end, actual.getCurrent().getStopIndex() + 1);
            return new Region(start, end - start);
        }

        private boolean inSync(TokenIterator previous, TokenIterator actual, int lengthDiff) {
            boolean equal = this.equal((Token)previous.getCurrent(), (Token)actual.getCurrent());
            int prevIndex = previous.getCurrent().getStartIndex() + lengthDiff;
            int startIndex = actual.getCurrent().getStartIndex();
            return equal && prevIndex == startIndex;
        }

        private boolean equal(Token t1, Token t2) {
            return t1.getText().equals(t2.getText());
        }

        private TokenIterator iterator(String string) {
            Lexer source = XtextDamagerRepairer.this.createLexer(string);
            return new TokenIterator((TokenSource)source);
        }
    });

    @Inject
    public XtextDamagerRepairer(ITokenScanner scanner, @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING") Provider<Lexer> lexer) {
        super(scanner);
        this.lexer = lexer;
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        this.previousContent.put(document, document.get());
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        if (documentPartitioningChanged) {
            return partition;
        }
        try {
            IRegion iRegion = (IRegion)this.cache.get((Object)e);
            return iRegion;
        }
        catch (Exception e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
            Region region = new Region(0, e.getDocument().getLength());
            return region;
        }
        finally {
            this.previousContent.put(this.fDocument, this.fDocument.get());
        }
    }

    protected Lexer createLexer(String string) {
        Lexer l = (Lexer)this.lexer.get();
        l.setCharStream((CharStream)new ANTLRStringStream(string));
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TokenIterator
    implements Iterator<CommonToken> {
        private final TokenSource tokenSource;
        private CommonToken nextToken;
        private CommonToken current;

        public TokenIterator(TokenSource tokenSource) {
            this.tokenSource = tokenSource;
        }

        public CommonToken getCurrent() {
            return this.current;
        }

        @Override
        public boolean hasNext() {
            if (this.nextToken != null) {
                return true;
            }
            CommonToken token = (CommonToken)this.tokenSource.nextToken();
            if (token.getType() == -1) {
                return false;
            }
            this.nextToken = token;
            return true;
        }

        @Override
        public CommonToken next() {
            try {
                if (this.hasNext()) {
                    this.current = this.nextToken;
                    CommonToken commonToken = this.nextToken;
                    return commonToken;
                }
                throw new IllegalStateException();
            }
            finally {
                this.nextToken = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

