/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingResourceDescriptions
implements IResourceDescriptions.IContextAware {
    @Inject
    private Provider<ResourceSetBasedResourceDescriptions> resourceSetDescriptionsProvider;
    private Map<URI, IResourceDescription> resourceDescriptions;

    public void setContext(Notifier ctx) {
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)ctx);
        if (resourceSet == null) {
            throw new NullPointerException();
        }
        Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), Adapter.class);
        if (adapter == null) {
            throw new IllegalArgumentException("No " + Adapter.class.getName() + " found");
        }
        if (adapter.getResourceDescriptionsMap() != null) {
            this.resourceDescriptions = adapter.getResourceDescriptionsMap();
        } else {
            ResourceSetBasedResourceDescriptions resourceSetBasedResourceDescriptions = (ResourceSetBasedResourceDescriptions)this.resourceSetDescriptionsProvider.get();
            resourceSetBasedResourceDescriptions.setContext((Notifier)resourceSet);
            this.initialize((IResourceDescriptions)resourceSetBasedResourceDescriptions, adapter);
            adapter.setResourceDescriptionsMap(this.resourceDescriptions);
        }
    }

    public void initialize(IResourceDescriptions shadowing, Adapter adapter) {
        this.resourceDescriptions = Maps.newHashMap();
        for (URI uri : adapter.getToBeUpdated()) {
            IResourceDescription description;
            if (this.resourceDescriptions.containsKey(uri) || (description = shadowing.getResourceDescription(uri)) == null) continue;
            this.resourceDescriptions.put(uri, description);
        }
        Iterable descriptions = adapter.getToBeShadowed().getAllResourceDescriptions();
        for (IResourceDescription desc : descriptions) {
            URI uri = desc.getURI();
            if (adapter.getDeletedUris().contains(uri) || this.resourceDescriptions.containsKey(uri)) continue;
            this.resourceDescriptions.put(uri, desc);
        }
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return this.resourceDescriptions.values();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        return this.resourceDescriptions.get(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends AdapterImpl {
        private IResourceDescriptions toBeShadowed;
        private Set<URI> deletedUris;
        private Set<URI> toBeUpdated;
        private Map<URI, IResourceDescription> resourceDescriptions;

        public Adapter(IResourceDescriptions toBeShadowed, Set<URI> toBeUpdated, Set<URI> deletedUris) {
            this.toBeShadowed = toBeShadowed;
            this.deletedUris = deletedUris;
            this.toBeUpdated = toBeUpdated;
        }

        public IResourceDescriptions getToBeShadowed() {
            return this.toBeShadowed;
        }

        public Set<URI> getDeletedUris() {
            return this.deletedUris;
        }

        public Set<URI> getToBeUpdated() {
            return this.toBeUpdated;
        }

        public boolean isAdapterForType(Object type) {
            return Adapter.class == type;
        }

        public Map<URI, IResourceDescription> getResourceDescriptionsMap() {
            return this.resourceDescriptions;
        }

        public void setResourceDescriptionsMap(Map<URI, IResourceDescription> resourceDescriptions) {
            this.resourceDescriptions = resourceDescriptions;
        }
    }
}

