/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateRequest;

public class QVTOVirtualProcess
extends PlatformObject
implements IProcess {
    private final ILaunch fLaunch;
    private final IQVTOVirtualMachineShell fVM;
    private IStreamsProxy fStreamsPxy;

    public QVTOVirtualProcess(ILaunch launch, IQVTOVirtualMachineShell vm) {
        this.fLaunch = launch;
        this.fVM = vm;
        this.fLaunch.addProcess((IProcess)this);
    }

    protected void terminated() {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            DebugEvent event = new DebugEvent((Object)this, 8);
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public void setStreamsProxy(IStreamsProxy streamsProxy) {
        this.fStreamsPxy = streamsProxy;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsPxy;
    }

    public String getLabel() {
        String transformationURI = null;
        ILaunchConfiguration configuration = this.fLaunch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                transformationURI = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)configuration).toString();
            }
            catch (CoreException e) {
                QVTODebugCore.log(e.getStatus());
            }
        }
        return transformationURI != null ? transformationURI : "QVTOProcess";
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public boolean isTerminated() {
        return this.fVM.isTerminated();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        try {
            this.fVM.sendRequest(new VMTerminateRequest());
        }
        catch (IOException e) {
            throw new DebugException(QVTODebugUtil.createDebugError("Process termination Failed", e));
        }
    }
}

