/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.QvtNamesChecker;
import org.eclipse.m2m.internal.qvt.oml.builder.QvtBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.QVTProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtCompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtNamespace;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtBaseElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtElementMemberColllector;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtRootNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtProject
extends QvtBaseElement
implements IQvtProject {
    private IProject fProject;
    private List<IQvtNamespace> rootNamespaces;
    private IQvtNamespace defaultNamespace;
    private IContainer srcContainer;

    public QvtProject(IProject project) {
        super(project.getFullPath(), project.getName());
        if (project == null) {
            throw new IllegalArgumentException();
        }
        this.fProject = project;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public IQvtProject getQvtProject() {
        return this;
    }

    @Override
    public IQvtNamespace getDefaultNamespace() throws QvtModelException {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = new QvtRootNamespace(this, "");
        }
        return this.defaultNamespace;
    }

    @Override
    public List<IQvtNamespace> getRootNamespaces() throws QvtModelException {
        if (this.rootNamespaces == null) {
            try {
                IContainer container = this.getSourceContainer();
                ArrayList<IQvtNamespace> result = new ArrayList<IQvtNamespace>();
                List<String> folderNames = QvtElementMemberColllector.getMemberNamespaces(container);
                for (String folderName : folderNames) {
                    result.add(new QvtRootNamespace(this, folderName));
                }
                IQvtNamespace virtualDefault = this.getDefaultNamespace();
                if (!virtualDefault.getCompilationUnits().isEmpty()) {
                    result.add(this.getDefaultNamespace());
                }
                this.rootNamespaces = result;
            }
            catch (CoreException e) {
                this.propagateAsQvtModelException(e);
            }
        }
        return this.rootNamespaces;
    }

    @Override
    public IPath getQvtSourceContainerPath() throws QvtModelException {
        return this.getSourceContainer().getFullPath();
    }

    public IContainer getSourceContainer() throws QvtModelException {
        if (this.srcContainer == null) {
            try {
                this.srcContainer = QvtBuilderConfig.getConfig((IProject)this.fProject).getSourceContainer();
            }
            catch (CoreException e) {
                this.propagateAsQvtModelException("Failed to read QVT builder config", e);
            }
        }
        return this.srcContainer;
    }

    @Override
    public int getElementType() {
        return 1;
    }

    @Override
    public IResource getUnderlyingResource() throws QvtModelException {
        return this.fProject;
    }

    public IQvtNamespace findRootNamespace(String namespaceSimpleName) throws QvtModelException {
        for (IQvtNamespace namespace : this.getRootNamespaces()) {
            if (!namespace.getName().equals(namespaceSimpleName)) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public IQvtCompilationUnit findCompilationUnit(String unitQualifiedName) throws QvtModelException {
        String localName = QvtNamesChecker.extractLocalIdentifierPart((String)unitQualifiedName);
        String namespace = QvtNamesChecker.extractQualifyingIdentifierPart((String)unitQualifiedName);
        IQvtNamespace owner = this.findNamespace(namespace);
        if (owner != null) {
            return owner.findCompilationUnit(localName);
        }
        return null;
    }

    @Override
    public IQvtNamespace findNamespace(String namespaceQualifiedName) throws QvtModelException {
        if ("".equals(namespaceQualifiedName)) {
            return this.getDefaultNamespace();
        }
        IStatus nameStatus = QvtNamesChecker.validateNamespaceQualifiedIdentifier((String)namespaceQualifiedName);
        if (!nameStatus.isOK()) {
            throw new IllegalArgumentException(nameStatus.getMessage());
        }
        String[] nsSegments = QvtNamesChecker.getQualifiedNameSegments((String)namespaceQualifiedName);
        IQvtNamespace rootNamespace = this.findRootNamespace(nsSegments[0]);
        if (rootNamespace == null) {
            return null;
        }
        if (nsSegments.length > 1) {
            ArrayList subNamespace = new ArrayList(Arrays.asList(nsSegments));
            subNamespace.remove(0);
            return QvtProject.findRecursively(subNamespace.toArray(new String[subNamespace.size()]), rootNamespace);
        }
        return rootNamespace;
    }

    @Override
    public IQvtElement findElement(IResource resource, boolean exactMatchOnly) throws QvtModelException {
        if (!this.fProject.equals((Object)resource.getProject())) {
            return null;
        }
        if (resource.getType() == 4) {
            return this;
        }
        IQvtElement element = this.findExactElement(resource);
        if (element == null && !exactMatchOnly && resource.getParent() != null) {
            element = this.findClosestElement((IResource)resource.getParent());
        }
        return element;
    }

    private IPath getPathInSrcContainer(IResource resource) {
        try {
            IPath containerPath = this.getSourceContainer().getFullPath();
            IPath resourcePath = resource.getFullPath();
            if (containerPath.equals((Object)resourcePath)) {
                return Path.ROOT;
            }
            if (containerPath.segmentCount() < resourcePath.segmentCount() && containerPath.isPrefixOf(resourcePath)) {
                return resourcePath.removeFirstSegments(containerPath.segmentCount());
            }
        }
        catch (QvtModelException e) {
            QVTProjectPlugin.log(e);
        }
        return null;
    }

    private IQvtElement findClosestElement(IResource resource) throws QvtModelException {
        IQvtElement element = this.findExactElement(resource);
        if (element == null) {
            if (resource.getType() == 4) {
                return this;
            }
            IContainer parent = resource.getParent();
            if (parent != null) {
                element = this.findClosestElement((IResource)parent);
            }
        }
        return element;
    }

    private IQvtElement findExactElement(IResource resource) throws QvtModelException {
        boolean isFile;
        IPath srcRelativePath = this.getPathInSrcContainer(resource);
        if (srcRelativePath == null) {
            return null;
        }
        if (srcRelativePath.isRoot()) {
            return this.getDefaultNamespace();
        }
        IPath namespacePath = srcRelativePath;
        boolean bl = isFile = resource.getType() == 1;
        if (isFile) {
            if (!QvtNamesChecker.isValidCompilationUnitFileName((String)resource.getName())) {
                return null;
            }
            namespacePath = srcRelativePath.segmentCount() > 1 ? srcRelativePath.removeLastSegments(1) : null;
        }
        IQvtNamespace namespace = null;
        if (namespacePath == null) {
            namespace = this.getDefaultNamespace();
        } else {
            IQvtNamespace root = this.findRootNamespace(namespacePath.segment(0));
            if (root != null) {
                namespace = namespacePath.segmentCount() > 1 ? QvtProject.findRecursively(namespacePath.removeFirstSegments(1).segments(), root) : root;
            }
        }
        if (isFile && namespace != null) {
            String cuName = QvtNamesChecker.getCompilationUnitMainModuleName((String)resource.getName());
            return namespace.findCompilationUnit(cuName);
        }
        return namespace;
    }

    private static IQvtNamespace findRecursively(String[] path, IQvtNamespace startNamespace) throws QvtModelException {
        IQvtNamespace parent = startNamespace;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String nameElement = stringArray[n2];
            IQvtNamespace next = parent.findOwnedNamespace(nameElement);
            if (next == null) {
                return null;
            }
            parent = next;
            ++n2;
        }
        return parent;
    }
}

