/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtValidator {
    private QvtValidator() {
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<TargetUriData> targetUris, String traceFilePath, boolean useTrace) throws MdaException {
        IStatus result = StatusUtil.makeOkStatus();
        Iterator<TargetUriData> itrTargetData = targetUris.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (!itrTargetData.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameter(transfParam, itrTargetData.next(), transformation.getResourceSet());
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        IStatus traceStatus = QvtValidator.validateTrace(traceFilePath, useTrace);
        if (StatusUtil.isError((IStatus)traceStatus)) {
            return traceStatus;
        }
        if (traceStatus.getSeverity() > result.getSeverity()) {
            result = traceStatus;
        }
        return result;
    }

    public static IStatus validateTransformation(QvtTransformation transformation, List<EObject> inObjs) throws MdaException {
        IStatus result = StatusUtil.makeOkStatus();
        Iterator<EObject> itrInObjs = inObjs.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.IN && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
            if (!itrInObjs.hasNext()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_MissedInputTransfParam, (Object)transfParam.getName()));
            }
            IStatus nextStatus = QvtValidator.validateTransformationParameterIn(transfParam, itrInObjs.next());
            if (nextStatus.getSeverity() <= result.getSeverity()) continue;
            result = nextStatus;
        }
        StringBuffer superfluousParams = new StringBuffer();
        while (itrInObjs.hasNext()) {
            if (superfluousParams.length() > 0) {
                superfluousParams.append(", ");
            }
            superfluousParams.append(EmfUtil.getFullName((EClassifier)itrInObjs.next().eClass()));
        }
        if (superfluousParams.length() > 0) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_SuperfluousInputTransfParam, (Object)superfluousParams.toString()));
        }
        return result;
    }

    public static IStatus validateTransformationParameter(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
            return QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        }
        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
            return QvtValidator.validateTransformationParameterInOut(transfParam, targetData, validationRS);
        }
        return QvtValidator.validateTransformationParameterOut(transfParam, targetData, validationRS);
    }

    public static IStatus validateTrace(String traceFilePath, boolean useTrace) {
        try {
            IStatus result = StatusUtil.makeOkStatus();
            if (useTrace) {
                if (traceFilePath == null || traceFilePath.length() == 0) {
                    return StatusUtil.makeErrorStatus((String)Messages.QvtValidator_NoTraceFile);
                }
                IFile workspaceFile = null;
                try {
                    URI traceUri = URI.createURI((String)traceFilePath);
                    workspaceFile = WorkspaceUtils.getWorkspaceFile((URI)traceUri);
                }
                catch (RuntimeException ex) {
                    IStatus status = StatusUtil.makeErrorStatus((String)"internal_error", (Exception)ex);
                    return status;
                }
                if (workspaceFile == null) {
                    IStatus status = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TraceNotInWorkspace, (Object)traceFilePath));
                    return status;
                }
                IProject project = workspaceFile.getProject();
                if (project == null || !project.isOpen()) {
                    String name = project == null ? "" : project.getName();
                    IStatus status = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_TraceProjectNotOpen, (Object)name));
                    return status;
                }
                if (!traceFilePath.endsWith(".qvtotrace") && result.getSeverity() < 2) {
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NoTraceFileExtension, (Object)".qvtotrace"));
                }
            }
            return result;
        }
        catch (Exception e) {
            return StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        block23: {
            if (transfParam.getMetamodels().isEmpty()) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            if (transfParam.getEntryType() == null) break block23;
            classifier = transfParam.getEntryType();
            sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
            in = null;
            rs = classifier.eResource() != null && classifier.eResource().getResourceSet() != null ? classifier.eResource().getResourceSet() : validationRS;
            try {
                in = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)rs);
            }
            catch (Exception v0) {}
            if (in == null) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
            }
            inputRs = rs == null ? in.eResource().getResourceSet() : null;
            try {
                try {
                    in = EmfUtil.resolveSource((EObject)in, (EObject)classifier);
                }
                catch (WrappedException v1) {
                    var9_13 = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                    if (inputRs == null) return var9_13;
                    var11_16 = inputRs.getResources().iterator();
                    if (true) ** GOTO lbl62
                }
                if (EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)in.eClass()) == false) return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)EmfUtil.getFullName((EClassifier)in.eClass()), (Object)EmfUtil.getFullName((EClassifier)classifier)));
                if (!classifier.isInstance((Object)in)) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)EmfUtil.getFullName((EClassifier)in.eClass()), (Object)EmfUtil.getFullName((EClassifier)classifier)));
                }
            }
            catch (Throwable var8_30) {}
        }
        metamodel = transfParam.getMetamodels().get(0);
        sourceUri = EmfUtil.makeUri((String)targetData.getUriString());
        in = null;
        rs = metamodel.eResource() != null && metamodel.eResource().getResourceSet() != null ? metamodel.eResource().getResourceSet() : validationRS;
        try {
            in = EmfUtil.loadModel((URI)sourceUri, (ResourceSet)rs);
        }
        catch (Exception v2) {}
        if (in == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
        }
        inputRs = rs == null ? in.eResource().getResourceSet() : null;
        try {
            try {
                in = EmfUtil.resolveSource((EObject)in, (EObject)metamodel);
            }
            catch (WrappedException v3) {
                var9_15 = StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidSourceUri, (Object)targetData.getUriString(), (Object)transfParam.getName()));
                if (inputRs == null) return var9_15;
                var11_20 = inputRs.getResources().iterator();
                if (true) ** GOTO lbl67
            }
        }
        catch (Throwable var8_31) {
            if (inputRs == null) throw var8_31;
            var11_21 = inputRs.getResources().iterator();
            if (true) ** GOTO lbl72
        }
        if (inputRs == null) return StatusUtil.makeOkStatus();
        var11_22 = inputRs.getResources().iterator();
        if (true) ** GOTO lbl77
        do {
            res = (Resource)var11_16.next();
            res.unload();
lbl62:
            // 2 sources

        } while (var11_16.hasNext());
        return var9_13;
        do {
            res = (Resource)var11_20.next();
            res.unload();
lbl67:
            // 2 sources

        } while (var11_20.hasNext());
        return var9_15;
        do {
            res = (Resource)var11_21.next();
            res.unload();
lbl72:
            // 2 sources

        } while (var11_21.hasNext());
        throw var8_31;
        do {
            res = (Resource)var11_22.next();
            res.unload();
lbl77:
            // 2 sources

        } while (var11_22.hasNext());
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterIn(QvtTransformation.TransformationParameter transfParam, EObject in) {
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        if (transfParam.getEntryType() != null) {
            EClassifier classifier = transfParam.getEntryType();
            if (!EmfUtil.isAssignableFrom((EClassifier)classifier, (EClassifier)in.eClass()) || !classifier.isInstance((Object)in)) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputTypes, (Object)EmfUtil.getFullName((EClassifier)in.eClass()), (Object)EmfUtil.getFullName((EClassifier)classifier)));
            }
        } else {
            EPackage metamodel = transfParam.getMetamodels().get(0);
            if (EcoreUtil.getRootContainer((EObject)in.eClass()) != metamodel) {
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_IncompatibleInputMetamodels, (Object)EmfUtil.getFullName((EClassifier)in.eClass()), (Object)EmfUtil.getMetamodelName((EPackage)metamodel)));
            }
        }
        return StatusUtil.makeOkStatus();
    }

    private static IStatus validateTransformationParameterInOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IMetamodelHandler handler;
        EClassifier classifier;
        IStatus result = QvtValidator.validateTransformationParameterIn(transfParam, targetData, validationRS);
        if (result.getSeverity() >= 2) {
            return result;
        }
        URI sourceUri = URI.createURI((String)targetData.getUriString());
        IFile file = WorkspaceUtils.getWorkspaceFile((URI)sourceUri);
        if (file != null && file.exists() && file.isReadOnly() && result.getSeverity() < 2) {
            result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationReadonly, (Object)sourceUri));
        }
        if ((classifier = transfParam.getEntryType()) == null) {
            classifier = transfParam.getMetamodels().get(0).eClass();
        }
        if ((handler = MetamodelHandlerManager.getInstance().getHandler(classifier)) == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_UnsupportedDestination, (Object)targetData.getUriString()));
        }
        IStatus canSave = handler.getSaver().canSave(classifier, sourceUri);
        if (StatusUtil.isError((IStatus)canSave)) {
            return canSave;
        }
        return result;
    }

    private static IStatus validateTransformationParameterOut(QvtTransformation.TransformationParameter transfParam, TargetUriData targetData, ResourceSet validationRS) {
        IMetamodelHandler handler;
        if (transfParam.getMetamodels().isEmpty()) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
        }
        EClassifier classifier = transfParam.getEntryType();
        if (classifier == null) {
            classifier = transfParam.getMetamodels().get(0).eClass();
        }
        if ((handler = MetamodelHandlerManager.getInstance().getHandler(classifier)) == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_UnsupportedDestination, (Object)targetData.getUriString()));
        }
        URI destUri = EmfUtil.makeUri((String)targetData.getUriString());
        if (destUri == null) {
            return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)targetData.getUriString()));
        }
        IStatus result = StatusUtil.makeOkStatus();
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                IStatus canSave;
                IFile file = WorkspaceUtils.getWorkspaceFile((URI)destUri);
                if (file != null && file.exists() && result.getSeverity() < 2) {
                    result = EmfUtil.isUriExisted((String)targetData.getUriString(), (ResourceSet)validationRS) ? StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri)) : StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExistsNonEObject, (Object)destUri));
                }
                if (StatusUtil.isError((IStatus)(canSave = handler.getSaver().canSave(classifier, destUri)))) {
                    return canSave;
                }
                if (canSave.getSeverity() > result.getSeverity()) {
                    result = canSave;
                }
                if (!destUri.hasFragment() || result.getSeverity() >= 2) break;
                result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_NewDestinationHasFragment, (Object)destUri.fragment()));
                break;
            }
            case EXISTING_CONTAINER: {
                IStatus canSave;
                EObject cont = EmfUtil.loadModel((URI)destUri);
                if (cont == null) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidTargetUri, (Object)destUri));
                }
                IFile file = WorkspaceUtils.getWorkspaceFile((URI)destUri);
                if (file != null && file.exists() && file.isReadOnly() && result.getSeverity() < 2) {
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationReadonly, (Object)destUri));
                }
                if (StatusUtil.isError((IStatus)(canSave = handler.getSaver().canSave(classifier, destUri)))) {
                    return canSave;
                }
                String feature = targetData.getFeature();
                if (feature == null || feature.trim().length() == 0) {
                    if (result.getSeverity() >= 2) break;
                    result = StatusUtil.makeWarningStatus((String)NLS.bind((String)Messages.QvtValidator_DestinationExists, (Object)destUri));
                    break;
                }
                EStructuralFeature eFeature = cont.eClass().getEStructuralFeature(feature);
                if (!(eFeature instanceof EReference)) {
                    return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)feature));
                }
                EReference ref = (EReference)eFeature;
                if (ref.isChangeable()) break;
                return StatusUtil.makeErrorStatus((String)NLS.bind((String)Messages.QvtValidator_InvalidFeature, (Object)ref.getName()));
            }
        }
        return result;
    }
}

