/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationImplementation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;
import org.eclipse.qvt.declarative.ecore.operations.AbstractValidatorOperations;
import org.eclipse.qvt.declarative.ecore.operations.EPackageOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationOperations
extends AbstractQVTRelationOperations {
    public static RelationOperations INSTANCE = new RelationOperations();

    public boolean checkEveryDomainIsARelationDomain(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        for (Domain domain : relation.getDomain()) {
            if (domain instanceof RelationDomain) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domain, context)};
            this.appendError(diagnostics, domain, QVTRelationMessages._UI_Relation_DomainIsNotARelationDomain, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public boolean checkAtLeastTwoDomains(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (relation.getDomain().size() < 2) {
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relation, context)};
            this.appendError(diagnostics, relation, QVTRelationMessages._UI_Relation_LessThanTwoDomains, messageSubstitutions);
            return false;
        }
        return true;
    }

    public boolean checkDomainTypedModelsMatchModelParameters(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int modelParameterCount;
        EList domains = rule.getDomain();
        EList modelParameters = rule.getTransformation().getModelParameter();
        int domainCount = domains.size();
        if (domainCount < (modelParameterCount = modelParameters.size())) {
            Object[] messageSubstitutions = new Object[]{domainCount, this.getObjectLabel((EObject)rule, context), modelParameterCount};
            this.appendError(diagnostics, rule, QVTRelationMessages._UI_Relation_DomainTypedModelsDoNotMatchModelParameters, messageSubstitutions);
            return false;
        }
        boolean allOk = true;
        int i = 0;
        while (i < domainCount) {
            Domain domain = (Domain)domains.get(i);
            TypedModel typedModel = domain.getTypedModel();
            if (i < modelParameterCount) {
                TypedModel modelParameter = (TypedModel)modelParameters.get(i);
                if (typedModel != null && typedModel != modelParameter && modelParameters.contains(typedModel)) {
                    Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domain, context), this.getObjectLabel((EObject)modelParameter, context)};
                    this.appendError(diagnostics, rule, QVTRelationMessages._UI_Relation_DomainTypedModelIsNotModelParameter, messageSubstitutions);
                    allOk = false;
                }
            } else if (typedModel != null) {
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domain, context)};
                this.appendError(diagnostics, rule, QVTRelationMessages._UI_Relation_DomainWithoutModelParameterMustBePrimitive, messageSubstitutions);
                allOk = false;
            }
            ++i;
        }
        return allOk;
    }

    public boolean checkNonTopLevelIsNotInvokedWarning(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean checkRelationImplsAreUniqueWarning(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        AbstractValidatorOperations.UniquenessChecker<EOperation, RelationImplementation> checker = new AbstractValidatorOperations.UniquenessChecker<EOperation, RelationImplementation>((AbstractValidatorOperations)this){

            protected EOperation getKey(RelationImplementation value) {
                return value.getImpl();
            }

            protected int getSeverity() {
                return 2;
            }
        };
        return checker.check(relation.getOperationalImpl(), QVTRelationMessages._UI_Relation_ImplIsNotUnique, (EObject)relation, diagnostics, context);
    }

    protected boolean checkTypesAreDeclaredByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context, Pattern pattern, String errorMessage) {
        if (pattern == null) {
            return true;
        }
        boolean allOk = true;
        for (OCLExpression expression : this.getPatternExpressions(pattern)) {
            for (VariableExp variableReference : this.getAllVariableReferences((EObject)expression)) {
                Variable variable = (Variable)variableReference.getReferredVariable();
                EClassifier type = this.getTransitiveElementType(variable.getEType());
                if (this.declaresType(relation, type)) continue;
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)type, context), this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)relation, context)};
                this.appendError(diagnostics, variableReference, errorMessage, messageSubstitutions);
                allOk = false;
            }
            for (Variable variable : this.getAllVariables((EObject)expression)) {
                EClassifier type = this.getTransitiveElementType(variable.getEType());
                if (this.declaresType(relation, type)) continue;
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)type, context), this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)relation, context)};
                this.appendError(diagnostics, variable, errorMessage, messageSubstitutions);
                allOk = false;
            }
        }
        return allOk;
    }

    protected boolean checkVariablesAreDefinedByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context, Pattern pattern, String errorMessage) {
        if (pattern == null) {
            return true;
        }
        boolean allOk = true;
        for (OCLExpression expression : this.getPatternExpressions(pattern)) {
            for (VariableExp variableReference : this.getAllVariableReferences((EObject)expression)) {
                Variable variable = (Variable)variableReference.getReferredVariable();
                if (this.definesVariable(relation, variable) || this.locallyDefined(variableReference)) continue;
                Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)relation, context)};
                this.appendError(diagnostics, variableReference, errorMessage, messageSubstitutions);
                allOk = false;
            }
        }
        return allOk;
    }

    public boolean checkVariablesAreUnique(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkUniqueNames(relation, (List)relation.getVariable(), QVTRelationMessages._UI_Relation_VariableNameIsNotUnique, diagnostics, context);
    }

    public boolean checkWhenTypesAreDeclaredByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = relation.getWhen();
        String errorMessage = QVTRelationMessages._UI_Relation_WhenTypeIsNotDeclaredByRelation;
        return this.checkTypesAreDeclaredByRelation(relation, diagnostics, context, pattern, errorMessage);
    }

    public boolean checkWhenVariablesAreDefinedByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = relation.getWhen();
        String errorMessage = QVTRelationMessages._UI_Relation_WhenVariableIsNotDefinedByRelation;
        return this.checkVariablesAreDefinedByRelation(relation, diagnostics, context, pattern, errorMessage);
    }

    public boolean checkWhereTypesAreDeclaredByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String errorMessage = QVTRelationMessages._UI_Relation_WhereTypeIsNotDeclaredByRelation;
        Pattern pattern = relation.getWhere();
        return this.checkTypesAreDeclaredByRelation(relation, diagnostics, context, pattern, errorMessage);
    }

    public boolean checkWhereVariablesAreDefinedByRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String errorMessage = QVTRelationMessages._UI_Relation_WhereVariableIsNotDefinedByRelation;
        Pattern pattern = relation.getWhere();
        return this.checkVariablesAreDefinedByRelation(relation, diagnostics, context, pattern, errorMessage);
    }

    public boolean declaresType(Relation relation, EClassifier type) {
        return this.isPredefinedType(type) || this.getDeclaredPackages(relation).contains(type.getEPackage());
    }

    public boolean definesVariable(Relation relation, Variable variable) {
        return relation.getVariable().contains((Object)variable);
    }

    public Set<Variable> getAllLocalVariables1(Collection<OCLExpression> expressions) {
        HashSet<Variable> variables = new HashSet<Variable>();
        for (OCLExpression expression : expressions) {
            TreeIterator i = expression.eAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof Variable)) continue;
                variables.add((Variable)eObject);
            }
        }
        return variables;
    }

    public Set<EPackage> getDeclaredPackages(Relation relation) {
        HashSet<EPackage> declaredPackages = new HashSet<EPackage>();
        for (Domain domain : relation.getDomain()) {
            TypedModel typedModel = domain.getTypedModel();
            if (typedModel == null) continue;
            for (EPackage usedPackage : typedModel.getUsedPackage()) {
                Set allUsedPackages = EPackageOperations.INSTANCE.getAllEPackages(usedPackage);
                declaredPackages.addAll(allUsedPackages);
            }
        }
        return declaredPackages;
    }

    public Collection<OCLExpression> getPatternExpressions(Pattern pattern) {
        ArrayList<OCLExpression> expressions = new ArrayList<OCLExpression>();
        for (Predicate predicate : pattern.getPredicate()) {
            OCLExpression conditionExpression = predicate.getConditionExpression();
            if (conditionExpression == null) continue;
            expressions.add(conditionExpression);
        }
        return expressions;
    }
}

