/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.imp.help.IMPHelpContextProvider;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.ui.PlatformUI;

public class IMPHelpContext
implements IContext2 {
    private final String fHelpText;
    private final String fTitle;

    public static void displayHelp(IHelpService helpSrvc, IParseController parseController, String contextId, Object[] selected) throws CoreException {
        Object context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            if (selected != null && selected.length > 0) {
                String helpText = IMPHelpContextProvider.buildHelpString(selected, helpSrvc, parseController);
                context = new IMPHelpContext((IContext)context, helpText);
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
        }
    }

    public IMPHelpContext(IContext context, String helpText) {
        this.fHelpText = helpText;
        this.fTitle = context instanceof IContext2 ? ((IContext2)context).getTitle() : "";
    }

    public IHelpResource[] getRelatedTopics() {
        return new IHelpResource[0];
    }

    public String getText() {
        return this.fHelpText;
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    public String getStyledText() {
        return this.fHelpText;
    }

    public String getTitle() {
        return this.fTitle;
    }
}

