/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;

public class ProblemCounter
extends AbstractProblemHandler {
    private static final ProblemHandler.Severity[] summarySeverities = new ProblemHandler.Severity[]{ProblemHandler.Severity.FATAL, ProblemHandler.Severity.ERROR, ProblemHandler.Severity.WARNING};
    private Map<ProblemHandler.Severity, Map<ProblemHandler.Phase, Integer>> problemsCounts = null;

    public ProblemCounter() {
        super(null);
    }

    public int getExactProblemCount(ProblemHandler.Severity problemSeverity) {
        Map<ProblemHandler.Phase, Integer> problemsCount;
        int sum = 0;
        if (this.problemsCounts != null && (problemsCount = this.problemsCounts.get(problemSeverity)) != null) {
            for (Integer problemCount : problemsCount.values()) {
                sum += problemCount.intValue();
            }
        }
        return sum;
    }

    public int getExactProblemCount(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase) {
        Integer problemCount;
        Map<ProblemHandler.Phase, Integer> problemsCount;
        int sum = 0;
        if (this.problemsCounts != null && (problemsCount = this.problemsCounts.get(problemSeverity)) != null && (problemCount = problemsCount.get(processingPhase)) != null) {
            sum += problemCount.intValue();
        }
        return sum;
    }

    public int getProblemCount() {
        int sum = 0;
        if (this.problemsCounts != null) {
            for (Map<ProblemHandler.Phase, Integer> problemsCount : this.problemsCounts.values()) {
                for (Integer problemCount : problemsCount.values()) {
                    sum += problemCount.intValue();
                }
            }
        }
        return sum;
    }

    public int getProblemCount(ProblemHandler.Phase processingPhase) {
        int sum = 0;
        if (this.problemsCounts != null) {
            for (Map<ProblemHandler.Phase, Integer> problemsCount : this.problemsCounts.values()) {
                Integer problemCount = problemsCount.get(processingPhase);
                if (problemCount == null) continue;
                sum += problemCount.intValue();
            }
        }
        return sum;
    }

    public int getRelevantProblemCount(ProblemHandler.Severity thresholdSeverity) {
        int sum = 0;
        if (this.problemsCounts != null) {
            for (ProblemHandler.Severity problemSeverity : this.problemsCounts.keySet()) {
                if (!this.isRelevantSeverity(problemSeverity, thresholdSeverity)) continue;
                Map<ProblemHandler.Phase, Integer> problemsCount = this.problemsCounts.get(problemSeverity);
                for (Integer problemCount : problemsCount.values()) {
                    sum += problemCount.intValue();
                }
            }
        }
        return sum;
    }

    public int getRelevantProblemCount(ProblemHandler.Severity thresholdSeverity, ProblemHandler.Phase processingPhase) {
        int sum = 0;
        if (this.problemsCounts != null) {
            for (ProblemHandler.Severity problemSeverity : this.problemsCounts.keySet()) {
                Map<ProblemHandler.Phase, Integer> problemsCount;
                Integer problemCount;
                if (!this.isRelevantSeverity(problemSeverity, thresholdSeverity) || (problemCount = (problemsCount = this.problemsCounts.get(problemSeverity)).get(processingPhase)) == null) continue;
                sum += problemCount.intValue();
            }
        }
        return sum;
    }

    public String getSummary() {
        if (this.problemsCounts != null) {
            StringBuilder s = new StringBuilder();
            ProblemHandler.Severity[] severityArray = summarySeverities;
            int n = summarySeverities.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemHandler.Severity thresholdSeverity = severityArray[n2];
                int count = 0;
                for (ProblemHandler.Severity problemSeverity : this.problemsCounts.keySet()) {
                    if (!this.isRelevantSeverity(problemSeverity, thresholdSeverity)) continue;
                    Map<ProblemHandler.Phase, Integer> problemsCount = this.problemsCounts.get(problemSeverity);
                    for (ProblemHandler.Phase problemPhase : problemsCount.keySet()) {
                        if (s.length() > 0) {
                            s.append(", ");
                        }
                        Integer problemCount = problemsCount.get(problemPhase);
                        s.append(problemCount);
                        s.append(" ");
                        s.append(problemPhase);
                        count += problemCount.intValue();
                    }
                }
                if (s.length() > 0) {
                    s.append(" ");
                    s.append(thresholdSeverity);
                    if (count != 1) {
                        s.append("s");
                    }
                    return s.toString();
                }
                ++n2;
            }
        }
        return "No problems";
    }

    private boolean isRelevantSeverity(ProblemHandler.Severity problemSeverity, ProblemHandler.Severity thresholdSeverity) {
        return problemSeverity.compareTo((Enum)thresholdSeverity) >= 0 && problemSeverity != ProblemHandler.Severity.CANCEL;
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        Integer problemCount;
        Map<ProblemHandler.Phase, Integer> problemsCount;
        if (this.problemsCounts == null) {
            this.problemsCounts = new HashMap<ProblemHandler.Severity, Map<ProblemHandler.Phase, Integer>>();
        }
        if ((problemsCount = this.problemsCounts.get(problemSeverity)) == null) {
            problemsCount = new HashMap<ProblemHandler.Phase, Integer>();
            this.problemsCounts.put(problemSeverity, problemsCount);
        }
        int newCount = (problemCount = problemsCount.get(processingPhase)) != null ? problemCount + 1 : 1;
        problemsCount.put(processingPhase, newCount);
    }

    public String toString() {
        return this.getSummary();
    }
}

