/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.qvt.declarative.ecore.utils.ClassUtils;
import org.eclipse.qvt.declarative.ecore.utils.XMIUtils;
import org.eclipse.qvt.declarative.editor.ui.utils.MissingElementException;
import org.eclipse.qvt.declarative.editor.ui.utils.MissingObjectException;
import org.eclipse.qvt.declarative.editor.ui.utils.MissingXmiIdException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUpdater {
    private final XMLResource resource;
    private final XMLResource newResource;
    private final Map<String, EObject> idToObjectMap = new HashMap<String, EObject>();
    private final Map<EObject, String> objectToIdMap = new HashMap<EObject, String>();
    private final Map<EObject, String> newObjectToIdMap = new HashMap<EObject, String>();

    public static void computeIdMaps(XMLResource resource, Map<String, EObject> idToObjectMap, Map<EObject, String> objectToIdMap) throws MissingXmiIdException {
        List<EObject> eObjects = EcoreUpdater.computeIdMaps(resource, idToObjectMap, objectToIdMap, null);
        if (eObjects != null) {
            throw new MissingXmiIdException(eObjects.get(0));
        }
    }

    public static List<EObject> computeIdMaps(XMLResource resource, Map<String, EObject> idToObjectMap, Map<EObject, String> objectToIdMap, XMIUtils.IdCreator idCreator) {
        String id;
        if (idToObjectMap != null) {
            idToObjectMap.clear();
        } else {
            idToObjectMap = new HashMap<String, EObject>();
        }
        if (objectToIdMap != null) {
            objectToIdMap.clear();
        }
        ArrayList<EObject> idLess = null;
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object instanceof EGenericType) continue;
            id = resource.getID(object);
            if (id == null) {
                if (idLess == null) {
                    idLess = new ArrayList<EObject>(100);
                }
                idLess.add(object);
                continue;
            }
            idToObjectMap.put(id, object);
            if (objectToIdMap == null) continue;
            objectToIdMap.put(object, id);
        }
        if (idLess != null) {
            if (idCreator == null) {
                if (objectToIdMap != null) {
                    for (EObject object : idLess) {
                        objectToIdMap.put(object, null);
                    }
                }
                return idLess;
            }
            for (EObject object : idLess) {
                id = idCreator.createId(object, idToObjectMap.keySet());
                idToObjectMap.put(id, object);
                if (objectToIdMap == null) continue;
                objectToIdMap.put(object, id);
            }
        }
        return null;
    }

    public static XMLResource copy(XMLResource oldResource) throws MissingXmiIdException {
        XMLResourceImpl newResource = new XMLResourceImpl();
        EcoreUpdater.copy((XMLResource)newResource, oldResource);
        return newResource;
    }

    public static void copy(XMLResource newResource, XMLResource oldResource) throws MissingXmiIdException {
        newResource.setURI(oldResource.getURI());
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        newResource.getContents().addAll(copier.copyAll((Collection)oldResource.getContents()));
        copier.copyReferences();
        for (EObject oldObject : copier.keySet()) {
            EObject newObject = (EObject)copier.get((Object)oldObject);
            if (newObject instanceof EGenericType) continue;
            String id = oldResource.getID(oldObject);
            if (id == null) {
                throw new MissingXmiIdException(oldObject);
            }
            newResource.setID(newObject, id);
        }
        TreeIterator iterator = newResource.getAllContents();
        while (iterator.hasNext()) {
            String id;
            EObject newObject = (EObject)iterator.next();
            if (newObject instanceof EGenericType || (id = newResource.getID(newObject)) != null) continue;
            EObject newContainer = newObject.eContainer();
            String containerId = newResource.getID(newContainer);
            if (containerId == null) {
                throw new MissingXmiIdException(newContainer);
            }
            EStructuralFeature containingFeature = newObject.eContainingFeature();
            EObject oldContainer = oldResource.getEObject(containerId);
            Object oldObject = oldContainer.eGet(containingFeature);
            if (containingFeature.isMany()) {
                List newList = (List)newContainer.eGet(containingFeature);
                int index = newList.indexOf(newObject);
                oldObject = ((List)oldObject).get(index);
            }
            id = oldResource.getID((EObject)oldObject);
            newResource.setID(newObject, id);
        }
    }

    public static void update(XMLResource oldResource, XMLResource newResource) throws MissingElementException {
        EcoreUpdater updater = new EcoreUpdater(oldResource, newResource);
        updater.initialize();
        updater.update();
    }

    public EcoreUpdater(XMLResource resource, XMLResource newResource) {
        this.resource = resource;
        this.newResource = newResource;
    }

    protected void installCopy(EObject oldObject, EObject newObject) {
        String id = this.newObjectToIdMap.get(newObject);
        this.resource.setID(oldObject, id);
        this.idToObjectMap.put(id, oldObject);
        this.objectToIdMap.put(oldObject, id);
        for (EStructuralFeature feature : newObject.eClass().getEAllStructuralFeatures()) {
            if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) continue;
            Object newValue = newObject.eGet(feature);
            Object oldValue = oldObject.eGet(feature);
            if (newValue == null) continue;
            if (!feature.isMany()) {
                this.installCopy((EObject)oldValue, (EObject)newValue);
                continue;
            }
            if (newValue instanceof List) {
                List newList = (List)newValue;
                List oldList = (List)oldValue;
                int i = 0;
                while (i < newList.size()) {
                    this.installCopy((EObject)oldList.get(i), (EObject)newList.get(i));
                    ++i;
                }
                continue;
            }
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".installCopy for " + newValue.getClass().getName());
        }
    }

    public void debug(PrintStream s) {
        System.out.println("-----------------------------------------------");
        ArrayList<String> keys = new ArrayList<String>(this.idToObjectMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            EObject object = this.idToObjectMap.get(key);
            if (object instanceof ENamedElement) {
                System.out.println(String.valueOf(key) + " ==> " + object.eClass().getName() + "." + ((ENamedElement)object).getName());
                continue;
            }
            System.out.println(String.valueOf(key) + " ==> " + object.eClass().getName());
        }
    }

    public void initialize() throws MissingXmiIdException {
        EcoreUpdater.computeIdMaps(this.resource, this.idToObjectMap, this.objectToIdMap);
        EcoreUpdater.computeIdMaps(this.newResource, null, this.newObjectToIdMap);
    }

    protected <E extends EObject> E newOldObjectFor(E newObject) throws MissingElementException {
        if (newObject == null) {
            return newObject;
        }
        if (newObject.eIsProxy()) {
            return newObject;
        }
        if (newObject.eResource() != this.newResource) {
            return newObject;
        }
        String id = this.newObjectToIdMap.get(newObject);
        if (id == null) {
            throw new MissingXmiIdException(newObject);
        }
        EObject oldObject = this.idToObjectMap.get(id);
        if (oldObject == null) {
            throw new MissingObjectException(newObject, id);
        }
        return (E)((EObject)ClassUtils.asClassUnchecked((Object)oldObject));
    }

    public void update() throws MissingElementException {
        this.updateList(null, (List)this.resource.getContents(), (List)this.newResource.getContents());
    }

    protected void updateEObject(EObject oldObject, EObject newObject) throws MissingElementException {
        EList features = oldObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object oldValue;
            if (feature.isDerived() || feature.isVolatile() || feature.isTransient()) continue;
            boolean oldIsSet = oldObject.eIsSet(feature);
            boolean newIsSet = newObject.eIsSet(feature);
            if (!newIsSet) {
                if (!oldIsSet) continue;
                oldObject.eUnset(feature);
                continue;
            }
            Object newValue = newObject.eGet(feature, false);
            if (feature instanceof EAttribute) {
                if (!oldIsSet) {
                    oldObject.eSet(feature, newValue);
                    continue;
                }
                oldValue = oldObject.eGet(feature, false);
                if (newValue == oldValue || newValue != null && newValue.equals(oldValue)) continue;
                oldObject.eSet(feature, newValue);
                continue;
            }
            if (!feature.isMany()) {
                if (((EReference)feature).isContainment()) {
                    oldValue = oldObject.eGet(feature, false);
                    if (oldIsSet && oldValue == null && newValue == null) continue;
                    this.updateEObject((EObject)oldValue, (EObject)newValue);
                    continue;
                }
                EObject newOldValue = this.newOldObjectFor((EObject)newValue);
                if (!oldIsSet) {
                    if (newOldValue != null && newOldValue.eIsProxy()) {
                        oldObject.eSet(feature, (Object)EcoreUtil.copy((EObject)newOldValue));
                        continue;
                    }
                    oldObject.eSet(feature, (Object)newOldValue);
                    continue;
                }
                Object oldValue2 = oldObject.eGet(feature, false);
                if (oldValue2 == newOldValue) continue;
                if (newOldValue != null && newOldValue.eIsProxy()) {
                    if (oldValue2 != null) {
                        ((InternalEObject)oldValue2).eSetProxyURI(((InternalEObject)newOldValue).eProxyURI());
                        continue;
                    }
                    oldObject.eSet(feature, (Object)EcoreUtil.copy((EObject)newOldValue));
                    continue;
                }
                oldObject.eSet(feature, (Object)newOldValue);
                continue;
            }
            if (newValue instanceof List) {
                oldValue = oldObject.eGet(feature, false);
                List oldList = (List)ClassUtils.asClassUnchecked((Object)oldValue);
                List newList = (List)ClassUtils.asClassUnchecked((Object)newValue);
                this.updateList((EReference)feature, oldList, newList);
                continue;
            }
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".updateEObject for " + newValue.getClass().getName());
        }
    }

    protected <E extends EObject> void updateList(EReference feature, List<E> oldList, List<E> newList) throws MissingElementException {
        boolean isContainment = feature == null || feature.isContainment();
        int iMaxNew = newList.size();
        int i = 0;
        while (i < iMaxNew) {
            int index;
            EObject oldObject;
            EObject newObject = (EObject)newList.get(i);
            if (isContainment) {
                String id = this.newObjectToIdMap.get(newObject);
                if (id == null) {
                    throw new MissingXmiIdException(newObject);
                }
                oldObject = this.idToObjectMap.get(id);
                if (oldObject == null || oldObject.eClass() != newObject.eClass()) {
                    oldObject = EcoreUtil.copy((EObject)newObject);
                    this.installCopy(oldObject, newObject);
                }
            } else {
                oldObject = this.newOldObjectFor(newObject);
            }
            if ((index = oldList.indexOf(oldObject)) != i) {
                if (index > i && oldList instanceof EList) {
                    ((EList)oldList).move(i, index);
                } else {
                    EObject oldE = (EObject)ClassUtils.asClassUnchecked((Object)oldObject);
                    oldList.add(i, oldE);
                }
            }
            if (isContainment) {
                this.updateEObject(oldObject, newObject);
            }
            ++i;
        }
        while (iMaxNew < oldList.size()) {
            oldList.remove(iMaxNew);
        }
    }
}

