/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.cst;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.imp.editor.IMPOutlinePage;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.cst.ICSTOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.format.DefaultFormatManager;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonTextEditor;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonTreeModelBuilder;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;

public abstract class CommonOutlinePage
extends IMPOutlinePage
implements ICSTOutlinePage,
ISelectionListener {
    protected final CommonTextEditor editor;
    protected final CommonTreeModelBuilder treeModelBuilder;
    private boolean changingSelection = false;

    public CommonOutlinePage(CommonTextEditor editor, CommonTreeModelBuilder treeModelBuilder) {
        super((IParseController)editor.getParseController(), (TreeModelBuilderBase)treeModelBuilder, editor.getLanguageServiceManager().getLabelProvider(), editor.getLanguageServiceManager().getImageProvider(), null, null);
        this.editor = editor;
        this.treeModelBuilder = treeModelBuilder;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.editor.removeModelListener((IModelListener)this);
    }

    protected ISelection getItemSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object[] selections = ((IStructuredSelection)selection).toArray();
            Object[] unwrappedSelections = new Object[selections.length];
            int i = 0;
            while (i < selections.length) {
                Object n = selections[i];
                while (n != null) {
                    ModelTreeNode item = this.treeModelBuilder.getItem(n);
                    if (item != null) {
                        unwrappedSelections[i] = item;
                        break;
                    }
                    Object object = n = n instanceof EObject ? ((EObject)n).eContainer() : null;
                }
                ++i;
            }
            selection = new StructuredSelection(unwrappedSelections);
        }
        return selection;
    }

    public void init(IPageSite pageSite) {
        this.editor.addModelListener((IModelListener)this);
        pageSite.getPage().addSelectionListener((ISelectionListener)this);
        pageSite.getPage().addPostSelectionListener((ISelectionListener)this);
        super.init(pageSite);
    }

    protected boolean isChangingSelection() {
        return this.changingSelection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.changingSelection) {
            if (QVTEditorPlugin.SELECTION_OUTER.isActive()) {
                QVTEditorPlugin.SELECTION_OUTER.println(this.getClass(), "selectionChanged1 " + DefaultFormatManager.formatDebug(event.getSelection()));
            }
            try {
                CSTNode cstNode;
                this.changingSelection = true;
                ISelection selection = event.getSelection();
                this.fireSelectionChanged(selection);
                if (!(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) return;
                Object object = ((IStructuredSelection)selection).getFirstElement();
                ICommonParseResult currentResult = this.editor.getParseController().getCurrentResult();
                CSTNode cSTNode = cstNode = currentResult != null ? currentResult.getCSTNode(object) : null;
                if (cstNode == null) return;
                this.editor.selectAndReveal(cstNode.getStartOffset(), cstNode.getEndOffset() - cstNode.getStartOffset() + 1);
                return;
            }
            finally {
                this.changingSelection = false;
            }
        } else {
            if (!QVTEditorPlugin.SELECTION_INNER.isActive()) return;
            QVTEditorPlugin.SELECTION_INNER.println(this.getClass(), "selectionChanged1 " + DefaultFormatManager.formatDebug(event.getSelection()));
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isChangingSelection()) {
            this.setSelection(selection);
        } else if (QVTEditorPlugin.SELECTION_INNER.isActive()) {
            QVTEditorPlugin.SELECTION_INNER.println(this.getClass(), "selectionChanged2 " + DefaultFormatManager.formatDebug(selection));
        }
    }

    public void setSelection(ISelection selection) {
        if (!this.changingSelection) {
            try {
                if (QVTEditorPlugin.SELECTION_OUTER.isActive()) {
                    QVTEditorPlugin.SELECTION_OUTER.println(this.getClass(), "setSelection " + DefaultFormatManager.formatDebug(selection));
                }
                this.changingSelection = true;
                ISelection itemSelection = this.getItemSelection(selection);
                super.setSelection(itemSelection);
            }
            finally {
                this.changingSelection = false;
            }
        }
    }

    public void update(IParseController parseController, IProgressMonitor monitor) {
        if (this.getTreeViewer() != null && this.getTreeViewer().getContentProvider() != null) {
            super.update(parseController, monitor);
        }
    }
}

