/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IFoldingUpdater;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class FoldingController
implements IModelListener {
    private final ProjectionAnnotationModel fAnnotationModel;
    private final IFoldingUpdater fFoldingUpdater;

    public FoldingController(ProjectionAnnotationModel annotationModel, IFoldingUpdater foldingUpdater) {
        this.fAnnotationModel = annotationModel;
        this.fFoldingUpdater = foldingUpdater;
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.SYNTACTIC_ANALYSIS;
    }

    public void update(IParseController parseController, IProgressMonitor monitor) {
        if (this.fAnnotationModel != null) {
            try {
                this.fFoldingUpdater.updateFoldingStructure(parseController, this.fAnnotationModel);
            }
            catch (Exception e) {
                RuntimePlugin.getInstance().logException("Error while updating folding annotations for " + parseController.getPath(), e);
            }
        }
    }
}

