/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.INavigationTargetFinder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class TargetNavigationAction
extends Action {
    protected UniversalEditor fEditor;
    protected INavigationTargetFinder fNavTargetFinder;

    protected abstract Object getNavTarget(Object var1, Object var2);

    protected TargetNavigationAction(String title, String actionDefID) {
        this(null, title, actionDefID);
    }

    public TargetNavigationAction(UniversalEditor editor, String title, String actionDefID) {
        this.setEditor((ITextEditor)editor);
        this.setText(title);
        this.setActionDefinitionId(actionDefID);
    }

    public void setEditor(ITextEditor editor) {
        this.fNavTargetFinder = null;
        if (editor instanceof UniversalEditor) {
            this.fEditor = (UniversalEditor)editor;
            if (this.fEditor.fLanguage != null) {
                this.fNavTargetFinder = ServiceFactory.getInstance().getNavigationTargetFinder(this.fEditor.fLanguage);
            }
        } else {
            this.fEditor = null;
        }
        this.setEnabled(this.fNavTargetFinder != null);
    }

    public void run() {
        Object prev;
        IRegion selection = this.fEditor.getSelectedRegion();
        IParseController pc = this.fEditor.getParseController();
        ISourcePositionLocator locator = pc.getSourcePositionLocator();
        Object curNode = locator.findNode(pc.getCurrentAst(), selection.getOffset(), selection.getOffset() + selection.getLength() - 1);
        if (curNode == null || selection.getOffset() == 0) {
            curNode = pc.getCurrentAst();
        }
        if ((prev = this.getNavTarget(curNode, pc.getCurrentAst())) != null) {
            int prevOffset = locator.getStartOffset(prev);
            this.fEditor.selectAndReveal(prevOffset, 0);
        }
    }
}

