/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHoverBase
implements IAnnotationHover,
ILanguageService {
    private static Set<String> sAnnotationTypesToFilter = new HashSet<String>();

    static {
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffUnchanged");
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffChange");
        sAnnotationTypesToFilter.add("org.eclipse.debug.core.breakpoint");
        sAnnotationTypesToFilter.add("org.eclipse.imp.runtime.occurrenceAnnotation");
        sAnnotationTypesToFilter.add("org.eclipse.projection");
    }

    protected static boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected static IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    public static List<Annotation> getSourceAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = AnnotationHoverBase.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        ArrayList<Annotation> srcAnnotations = new ArrayList<Annotation>();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = model.getPosition(annotation);
            if (position == null || !AnnotationHoverBase.isRulerLine(position, document, line)) continue;
            if (annotation instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation;
                for (Annotation bagAnnotation : bag) {
                    position = model.getPosition(bagAnnotation);
                    if (position == null || !AnnotationHoverBase.includeAnnotation(bagAnnotation, position)) continue;
                    srcAnnotations.add(bagAnnotation);
                }
                continue;
            }
            if (!AnnotationHoverBase.includeAnnotation(annotation, position)) continue;
            srcAnnotations.add(annotation);
        }
        return srcAnnotations;
    }

    private static boolean includeAnnotation(Annotation annotation, Position position) {
        String type = annotation.getType();
        return !sAnnotationTypesToFilter.contains(type);
    }

    public static String formatAnnotationList(List<Annotation> javaAnnotations) {
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = javaAnnotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return HTMLPrinter.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>(javaAnnotations.size());
                for (Annotation annotation : javaAnnotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return HTMLPrinter.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return HTMLPrinter.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List<Annotation> javaAnnotations = AnnotationHoverBase.getSourceAnnotationsForLine(sourceViewer, lineNumber);
        return AnnotationHoverBase.formatAnnotationList(javaAnnotations);
    }
}

