/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.m2m.atl.adt.launching.DialogUriSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModelChoiceTab
extends AbstractLaunchConfigurationTab {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private Map input = new HashMap();
    private Map output = new HashMap();
    private Map modelPath = new HashMap();
    private Map modelType = new HashMap();
    private Map modelHandler = new HashMap();
    private Map libPath = new HashMap();
    static final int INPUT = 0;
    static final int OUTPUT = 1;
    static final String MODEL = "MODEL";
    static final String METAMODEL = "METAMODEL";
    static final String LIB = "LIB";
    public static final String MODEL_OUTPUT = "MODELOUTPUT";
    public static final String MODEL_INPUT = "MODELINPUT";
    public static final String METAMODEL_OUTPUT = "METAMODELOUTPUT";
    public static final String METAMODEL_INPUT = "METAMODELINPUT";
    static final int TABLEPATHNAME = 0;
    static final int TABLEPATHPATH = 1;
    static final int TABLEPATHMODELHANDLER = 2;
    static final int TABLEPATHTYPE = 3;
    static final int TABLEMODELNAME = 0;
    static final int TABLEMETAMODELNAME = 1;
    static final int TABLELIBNAME = 0;
    static final int TABLELIBPATH = 1;
    private Composite container;
    private Group groupIn;
    private Table tableIn;
    private Text textModelIn;
    private Label labelModelIn;
    private Text textMetaModelIn;
    private Label labelMetaModelIn;
    private Button buttonIn;
    private Button buttonRemoveIn;
    private Group groupOut;
    private Table tableOut;
    private Text textModelOut;
    private Label labelModelOut;
    private Text textMetaModelOut;
    private Label labelMetaModelOut;
    private Button buttonOut;
    private Button buttonRemoveOut;
    private Group groupPath;
    private Table tablePath;
    private Button buttonSetPath;
    private Button buttonSetExternalPath;
    private Button buttonIsMDR;
    private Button buttonIsEMF;
    private List listModelHandlerAvailables;
    private Button buttonSelectModelHandler;
    private Button buttonAffectUri;
    private Group groupLib;
    private Table tableLib;
    private Text textLib;
    private Label labelLib;
    private Button buttonLib;
    private Button buttonPathLib;
    private Button buttonRemoveLib;
    private Button buttonExternalPathLib;

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.groupIn = new Group(this.container, 0);
        this.labelModelIn = new Label((Composite)this.groupIn, 0x1000008);
        this.textModelIn = new Text((Composite)this.groupIn, 2048);
        this.labelMetaModelIn = new Label((Composite)this.groupIn, 0x1000008);
        this.textMetaModelIn = new Text((Composite)this.groupIn, 2048);
        this.tableIn = new Table((Composite)this.groupIn, 67584);
        this.buttonIn = new Button((Composite)this.groupIn, 0);
        this.buttonRemoveIn = new Button((Composite)this.groupIn, 0);
        this.groupOut = new Group(this.container, 0);
        this.labelModelOut = new Label((Composite)this.groupOut, 0x1000008);
        this.textModelOut = new Text((Composite)this.groupOut, 2048);
        this.labelMetaModelOut = new Label((Composite)this.groupOut, 0x1000008);
        this.textMetaModelOut = new Text((Composite)this.groupOut, 2048);
        this.tableOut = new Table((Composite)this.groupOut, 67584);
        this.buttonOut = new Button((Composite)this.groupOut, 0x1000000);
        this.buttonRemoveOut = new Button((Composite)this.groupOut, 0);
        this.groupPath = new Group(this.container, 0);
        this.tablePath = new Table((Composite)this.groupPath, 67584);
        this.listModelHandlerAvailables = new List((Composite)this.groupPath, 2060);
        this.buttonSelectModelHandler = new Button((Composite)this.groupPath, 0x1000000);
        this.buttonSetPath = new Button((Composite)this.groupPath, 0x1000000);
        this.buttonSetExternalPath = new Button((Composite)this.groupPath, 0x1000000);
        this.buttonIsMDR = new Button((Composite)this.groupPath, 0x1000000);
        this.buttonIsEMF = new Button((Composite)this.groupPath, 0x1000000);
        this.buttonAffectUri = new Button((Composite)this.groupPath, 0x1000000);
        this.groupLib = new Group(this.container, 0);
        this.labelLib = new Label((Composite)this.groupLib, 0x1000008);
        this.textLib = new Text((Composite)this.groupLib, 2048);
        this.buttonLib = new Button((Composite)this.groupLib, 0x1000000);
        this.tableLib = new Table((Composite)this.groupLib, 67584);
        this.buttonPathLib = new Button((Composite)this.groupLib, 0x1000000);
        this.buttonExternalPathLib = new Button((Composite)this.groupLib, 0x1000000);
        this.buttonRemoveLib = new Button((Composite)this.groupLib, 0x1000000);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.container.setLayout((Layout)layout);
        this.groupIn.setLayoutData((Object)new GridData(1808));
        this.groupOut.setLayoutData((Object)new GridData(1808));
        this.groupPath.setLayoutData((Object)new GridData(1808));
        this.groupLib.setLayoutData((Object)new GridData(1808));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupIn.setLayout((Layout)groupLayout);
        this.groupIn.setText(Messages.getString("ModelChoiceTab.IN"));
        this.labelModelIn.setText(Messages.getString("ModelChoiceTab.MODELCOLON"));
        this.labelMetaModelIn.setText(Messages.getString("ModelChoiceTab.METAMODELCOLON"));
        this.buttonIn.setText(Messages.getString("ModelChoiceTab.ADD"));
        this.buttonIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.addTextTable(evt, ModelChoiceTab.this.tableIn, ModelChoiceTab.this.textModelIn, ModelChoiceTab.this.textMetaModelIn, 0);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveIn.setText(Messages.getString("ModelChoiceTab.REMOVE"));
        this.buttonRemoveIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.removeTextTable(evt, ModelChoiceTab.this.tableIn);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.tableIn.setLinesVisible(true);
        this.tableIn.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.tableIn.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        TableColumn modelNameIn = new TableColumn(this.tableIn, 0x1000000);
        modelNameIn.setText(Messages.getString("ModelChoiceTab.MODEL"));
        TableColumn mmodelNameIn = new TableColumn(this.tableIn, 0x1000000);
        mmodelNameIn.setText(Messages.getString("ModelChoiceTab.META_MODEL"));
        this.labelModelIn.setLayoutData((Object)new GridData(896));
        this.textMetaModelIn.setLayoutData((Object)new GridData(800));
        this.labelMetaModelIn.setLayoutData((Object)new GridData(896));
        this.textModelIn.setLayoutData((Object)new GridData(800));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 2;
        this.tableIn.setLayoutData((Object)gd);
        this.buttonIn.setLayoutData((Object)new GridData(770));
        this.buttonRemoveIn.setLayoutData((Object)new GridData(770));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupOut.setLayout((Layout)groupLayout);
        this.groupOut.setText(Messages.getString("ModelChoiceTab.OUT"));
        this.labelModelOut.setText(Messages.getString("ModelChoiceTab.MODELCOLON"));
        this.labelMetaModelOut.setText(Messages.getString("ModelChoiceTab.METAMODELCOLON"));
        this.buttonOut.setText(Messages.getString("ModelChoiceTab.ADD"));
        this.buttonOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.addTextTable(evt, ModelChoiceTab.this.tableOut, ModelChoiceTab.this.textModelOut, ModelChoiceTab.this.textMetaModelOut, 1);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveOut.setText(Messages.getString("ModelChoiceTab.REMOVE"));
        this.buttonRemoveOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.removeTextTable(evt, ModelChoiceTab.this.tableOut);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        tableLayout = new TableLayout();
        this.tableOut.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableOut.setLinesVisible(true);
        this.tableOut.setHeaderVisible(true);
        TableColumn modelName = new TableColumn(this.tableOut, 0x1000000);
        modelName.setText(Messages.getString("ModelChoiceTab.MODEL"));
        TableColumn metaModelName = new TableColumn(this.tableOut, 0x1000000);
        metaModelName.setText(Messages.getString("ModelChoiceTab.META_MODEL"));
        this.labelModelOut.setLayoutData((Object)new GridData(896));
        this.textModelOut.setLayoutData((Object)new GridData(800));
        this.labelMetaModelOut.setLayoutData((Object)new GridData(896));
        this.textMetaModelOut.setLayoutData((Object)new GridData(800));
        this.tableOut.setLayoutData((Object)gd);
        this.buttonOut.setLayoutData((Object)new GridData(770));
        this.buttonRemoveOut.setLayoutData((Object)new GridData(770));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupPath.setLayout((Layout)groupLayout);
        this.groupPath.setText(Messages.getString("ModelChoiceTab.PATH_EDITOR"));
        this.buttonSetPath.setText(Messages.getString("ModelChoiceTab.SET_PATH"));
        this.buttonSetPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.editPath(ModelChoiceTab.MODEL, ModelChoiceTab.this.tablePath);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonSetExternalPath.setText(Messages.getString("ModelChoiceTab.SET_EXTERNAL_PATH"));
        this.buttonSetExternalPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.editExternalPath(ModelChoiceTab.MODEL, ModelChoiceTab.this.tablePath);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonIsMDR.setText("MM Is MOF-1.4");
        this.buttonIsMDR.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.metamodelIsMetametamodel("MDR");
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonIsEMF.setText("MM is Ecore");
        this.buttonIsEMF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.metamodelIsMetametamodel("EMF");
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.listModelHandlerAvailables.setItems(AtlModelHandler.getModelHandlers());
        this.buttonSelectModelHandler.setText("Select Model Handler");
        this.buttonSelectModelHandler.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.selectModelHandler();
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonAffectUri.setText("Metamodel by URI");
        this.buttonAffectUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = ModelChoiceTab.this.tablePath.getSelectionIndex();
                if (index == -1) {
                    AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + "Metamodel");
                    return;
                }
                if (ModelChoiceTab.MODEL_INPUT.equals(ModelChoiceTab.this.tablePath.getItem(index).getText(3)) || ModelChoiceTab.MODEL_OUTPUT.equals(ModelChoiceTab.this.tablePath.getItem(index).getText(3))) {
                    AtlLauncherTools.messageBox("This action is only available on metamodel");
                    return;
                }
                DialogUriSelection launcher = new DialogUriSelection(new Shell());
                launcher.create();
                if (launcher.open() == 0) {
                    ModelChoiceTab.this.uriMetametamodel(launcher.getUriSelected());
                    ModelChoiceTab.this.canSave();
                    ModelChoiceTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        tableLayout = new TableLayout();
        this.tablePath.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        this.tablePath.setLinesVisible(true);
        this.tablePath.setHeaderVisible(true);
        TableColumn modelPathName = new TableColumn(this.tablePath, 0x1000000);
        modelPathName.setText(Messages.getString("ModelChoiceTab.MODEL"));
        TableColumn pathName = new TableColumn(this.tablePath, 16384);
        pathName.setText(Messages.getString("ModelChoiceTab.PATH"));
        TableColumn modelHandler = new TableColumn(this.tablePath, 0x1000000);
        modelHandler.setText("Model Handler");
        TableColumn modelType = new TableColumn(this.tablePath, 0);
        modelType.setText("Type");
        modelType.setWidth(0);
        modelType.setResizable(false);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 7;
        this.tablePath.setLayoutData((Object)gd);
        this.buttonSetPath.setLayoutData((Object)new GridData(770));
        this.buttonSetExternalPath.setLayoutData((Object)new GridData(770));
        this.buttonIsMDR.setLayoutData((Object)new GridData(770));
        this.buttonIsEMF.setLayoutData((Object)new GridData(770));
        GridData gData = new GridData(770);
        gData.heightHint = this.listModelHandlerAvailables.getItemHeight() * 2;
        this.listModelHandlerAvailables.setLayoutData((Object)gData);
        this.buttonSelectModelHandler.setLayoutData((Object)new GridData(770));
        this.buttonAffectUri.setLayoutData((Object)new GridData(770));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupLib.setLayout((Layout)groupLayout);
        this.groupLib.setText(Messages.getString("ModelChoiceTab.LIBS"));
        this.labelLib.setText(Messages.getString("ModelChoiceTab.LIBCOLON"));
        this.buttonLib.setText(Messages.getString("ModelChoiceTab.ADD"));
        this.buttonLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.addLib();
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonPathLib.setText(Messages.getString("ModelChoiceTab.SET_PATH"));
        this.buttonPathLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.editPath(ModelChoiceTab.LIB, ModelChoiceTab.this.tableLib);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonExternalPathLib.setText(Messages.getString("ModelChoiceTab.SET_EXTERNAL_PATH"));
        this.buttonExternalPathLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.editExternalPath(ModelChoiceTab.LIB, ModelChoiceTab.this.tableLib);
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveLib.setText(Messages.getString("ModelChoiceTab.REMOVE_LIB"));
        this.buttonRemoveLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ModelChoiceTab.this.removeLib();
                ModelChoiceTab.this.canSave();
                ModelChoiceTab.this.updateLaunchConfigurationDialog();
            }
        });
        tableLayout = new TableLayout();
        this.tableLib.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableLib.setLinesVisible(true);
        this.tableLib.setHeaderVisible(true);
        TableColumn libName = new TableColumn(this.tableLib, 0x1000000);
        libName.setText(Messages.getString("ModelChoiceTab.LIBS"));
        TableColumn pathLib = new TableColumn(this.tableLib, 16384);
        pathLib.setText(Messages.getString("ModelChoiceTab.PATH"));
        gd = new GridData(896);
        gd.horizontalSpan = 2;
        this.labelLib.setLayoutData((Object)gd);
        this.textLib.setLayoutData((Object)new GridData(800));
        this.buttonLib.setLayoutData((Object)new GridData(768));
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 3;
        this.tableLib.setLayoutData((Object)gd);
        this.buttonPathLib.setLayoutData((Object)new GridData(770));
        this.buttonRemoveLib.setLayoutData((Object)new GridData(770));
        this.buttonExternalPathLib.setLayoutData((Object)new GridData(770));
        this.setControl((Control)this.container);
        this.canSave();
    }

    private void removeLib() {
        int index = this.tableLib.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.CHOOSEMODEL"));
            return;
        }
        MessageBox msgBox = new MessageBox(this.getShell(), 65728);
        msgBox.setText(Messages.getString("ModelChoiceTab.ERROR"));
        msgBox.setMessage(Messages.getString("ModelChoiceTab.REMOVELIB"));
        if (msgBox.open() != 64) {
            return;
        }
        this.tableLib.remove(index);
    }

    private void removeTextTable(SelectionEvent evt, Table table) {
        String typeItem;
        String nameItem;
        int i;
        int index = table.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.CHOOSEMODEL"));
            return;
        }
        MessageBox msgBox = new MessageBox(this.getShell(), 65728);
        msgBox.setText(Messages.getString("ModelChoiceTab.ERROR"));
        msgBox.setMessage(Messages.getString("ModelChoiceTab.REMOVEMODEL"));
        if (msgBox.open() != 64) {
            return;
        }
        TableItem item = table.getItem(index);
        String modelName = item.getText(0);
        String metaModelName = item.getText(1);
        int indexModel = -1;
        int indexMetaModel = -1;
        TableItem[] items = this.tablePath.getItems();
        if (!this.isMultipleInstance(modelName, MODEL)) {
            i = 0;
            while (i < items.length) {
                nameItem = items[i].getText(0);
                typeItem = items[i].getText(3);
                if (modelName.equals(nameItem) && (typeItem.equals(MODEL_INPUT) || typeItem.equals(MODEL_OUTPUT))) {
                    indexModel = i;
                }
                ++i;
            }
            if (indexModel != -1) {
                this.tablePath.remove(indexModel);
            }
        }
        if (!this.isMultipleInstance(metaModelName, METAMODEL)) {
            items = this.tablePath.getItems();
            i = 0;
            while (i < items.length) {
                nameItem = items[i].getText(0);
                typeItem = items[i].getText(3);
                if (metaModelName.equals(nameItem) && (typeItem.equals(METAMODEL_INPUT) || typeItem.equals(METAMODEL_OUTPUT))) {
                    indexMetaModel = i;
                }
                ++i;
            }
            if (indexMetaModel != -1) {
                this.tablePath.remove(indexMetaModel);
            }
        }
        table.remove(index);
    }

    private boolean isMultipleInstance(String text, String type) {
        int textIndex = type.equals(MODEL) ? 0 : 1;
        boolean ok = false;
        int i = 0;
        while (i < this.tableOut.getItemCount()) {
            if (text.equals(this.tableOut.getItem(i).getText(textIndex))) {
                if (ok) {
                    return true;
                }
                ok = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.tableIn.getItemCount()) {
            if (text.equals(this.tableIn.getItem(i).getText(textIndex))) {
                if (ok) {
                    return true;
                }
                ok = true;
            }
            ++i;
        }
        return false;
    }

    private void addLib() {
        String lib = this.textLib.getText();
        if (lib.equals("")) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.GIVELIB"));
            return;
        }
        TableItem item = new TableItem(this.tableLib, 0);
        item.setText(new String[]{lib, ""});
        this.textLib.setText("");
    }

    private void uriMetametamodel(String uri) {
        int index = this.tablePath.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + "Metamodel");
            return;
        }
        if (MODEL_INPUT.equals(this.tablePath.getItem(index).getText(3)) || MODEL_OUTPUT.equals(this.tablePath.getItem(index).getText(3))) {
            AtlLauncherTools.messageBox("This action is only available on metamodel");
            return;
        }
        this.tablePath.getItem(index).setText(1, "uri:" + uri);
    }

    private void metamodelIsMetametamodel(String metamodel) {
        int index = this.tablePath.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + "Metamodel");
            return;
        }
        if (MODEL_INPUT.equals(this.tablePath.getItem(index).getText(3)) || MODEL_OUTPUT.equals(this.tablePath.getItem(index).getText(3))) {
            AtlLauncherTools.messageBox("This action is only available on metamodel");
            return;
        }
        this.tablePath.getItem(index).setText(1, "#" + metamodel);
        this.tablePath.getItem(index).setText(2, metamodel);
    }

    private void selectModelHandler() {
        int index = this.tablePath.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + "Metamodel");
            return;
        }
        if (MODEL_INPUT.equals(this.tablePath.getItem(index).getText(3)) || MODEL_OUTPUT.equals(this.tablePath.getItem(index).getText(3))) {
            AtlLauncherTools.messageBox("This action is only available on metamodel");
            return;
        }
        String[] selection = this.listModelHandlerAvailables.getSelection();
        if (selection.length == 1) {
            this.tablePath.getItem(index).setText(2, selection[0]);
            if (this.tablePath.getItem(index).getText(1).startsWith("#")) {
                this.tablePath.getItem(index).setText(1, "#" + selection[0]);
            }
        } else {
            AtlLauncherTools.messageBox("Please select a model handler");
            return;
        }
    }

    private void editExternalPath(String type, Table table) {
        int index = table.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            return;
        }
        if (type.equals(MODEL) && table.getItem(index).getText(3).equals(MODEL_OUTPUT)) {
            SaveAsDialog sad = new SaveAsDialog(this.getShell());
            sad.open();
            IPath outputPath = sad.getResult();
            if (outputPath != null) {
                TableItem item = table.getItem(index);
                item.setText(new String[]{item.getText(0), outputPath.toFile().getName(), item.getText(2), item.getText(3)});
            } else {
                AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            }
        } else {
            FileDialog fileDialog = new FileDialog(this.getShell());
            fileDialog.setText(Messages.getString("ModelChoiceTab.CHOOSEMETAMODEL"));
            fileDialog.setFilterExtensions(new String[]{"*"});
            String fileName = fileDialog.open();
            if (fileName == null) {
                return;
            }
            if ((fileName = "ext:" + fileName) != null) {
                TableItem item = table.getItem(index);
                if (type.equals(MODEL)) {
                    item.setText(new String[]{item.getText(0), fileName, item.getText(2), item.getText(3)});
                } else {
                    item.setText(new String[]{item.getText(0), fileName});
                }
            } else {
                AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            }
        }
    }

    private void editPath(final String type, Table table) {
        int index = table.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            return;
        }
        if (type.equals(MODEL) && table.getItem(index).getText(3).equals(MODEL_OUTPUT)) {
            SaveAsDialog sad = new SaveAsDialog(this.getShell());
            sad.open();
            IPath outputPath = sad.getResult();
            if (outputPath != null) {
                TableItem item = table.getItem(index);
                item.setText(new String[]{item.getText(0), outputPath.toString(), item.getText(2), item.getText(3)});
            } else {
                AtlLauncherTools.messageBox(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            }
        } else {
            ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            elementTreeSelectionDialog.setMessage(String.valueOf(Messages.getString("ModelChoiceTab.CHOOSE")) + type);
            elementTreeSelectionDialog.setAllowMultiple(false);
            elementTreeSelectionDialog.setDoubleClickSelects(true);
            elementTreeSelectionDialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    boolean ret = false;
                    if (element instanceof IContainer) {
                        ret = true;
                    } else if (element instanceof IFile) {
                        IFile currentFile = (IFile)element;
                        if (currentFile.getFileExtension() == null) {
                            return false;
                        }
                        ret = type == ModelChoiceTab.LIB ? currentFile.getFileExtension().toUpperCase().equals("ASM") : true;
                    }
                    return ret;
                }
            });
            elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    IStatus ret = Status.CANCEL_STATUS;
                    if (selection.length == 1 && selection[0] instanceof IFile) {
                        ret = Status.OK_STATUS;
                    }
                    return ret;
                }
            });
            elementTreeSelectionDialog.open();
            Object result = elementTreeSelectionDialog.getFirstResult();
            if (result != null && result instanceof IFile) {
                TableItem item = table.getItem(index);
                IFile currentFile = (IFile)result;
                if (type.equals(MODEL)) {
                    item.setText(new String[]{item.getText(0), currentFile.getFullPath().toString(), item.getText(2), item.getText(3)});
                } else {
                    item.setText(new String[]{item.getText(0), currentFile.getFullPath().toString()});
                }
            }
        }
    }

    private boolean isAlreadyInTransformation(String name, String type) {
        int i = 0;
        while (i < this.tablePath.getItemCount()) {
            String nameItem = this.tablePath.getItem(i).getText(0);
            String typeItem = this.tablePath.getItem(i).getText(3);
            if (name.equals(nameItem) && typeItem.equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String currentType(int type, String typeModel) {
        String currentType = type == 0 ? (typeModel.equals(MODEL) ? MODEL_INPUT : METAMODEL_INPUT) : (typeModel.equals(MODEL) ? MODEL_OUTPUT : METAMODEL_OUTPUT);
        return currentType;
    }

    private boolean tupleAlreadyInTable(String mName, String mmName, Table table) {
        int i = 0;
        while (i < table.getItemCount()) {
            if (mName.equals(table.getItem(i).getText(0)) && mmName.equals(table.getItem(i).getText(1))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addTextTable(SelectionEvent se, Table tableParam, Text model, Text metaModel, int type) {
        String metaModelName;
        if (model.getText().equals("")) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.GIVEMODEL"));
            return;
        }
        if (metaModel.getText().equals("")) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.GIVEMETAMODEL"));
            return;
        }
        String modelName = model.getText();
        if (this.tupleAlreadyInTable(modelName, metaModelName = metaModel.getText(), tableParam)) {
            AtlLauncherTools.messageBox(Messages.getString("ModelChoiceTab.ALREADYINTABLE"));
            return;
        }
        TableItem item = new TableItem(tableParam, 0);
        item.setText(new String[]{modelName, metaModelName});
        String currentType = this.currentType(type, MODEL);
        if (!this.isAlreadyInTransformation(modelName, MODEL_INPUT) && !this.isAlreadyInTransformation(modelName, MODEL_OUTPUT)) {
            item = new TableItem(this.tablePath, 0);
            item.setText(0, modelName);
            item.setText(1, "");
            item.setText(2, "");
            item.setText(3, currentType);
        }
        currentType = this.currentType(type, METAMODEL);
        if (!(this.isAlreadyInTransformation(metaModelName, METAMODEL_INPUT) || this.isAlreadyInTransformation(metaModelName, METAMODEL_OUTPUT) || this.isMetaModelOfRepository(metaModelName))) {
            TableItem itemPath = new TableItem(this.tablePath, 0);
            itemPath.setText(0, metaModelName);
            itemPath.setText(1, "");
            itemPath.setText(2, "EMF");
            itemPath.setText(3, currentType);
        }
        model.setText("");
        metaModel.setText("");
    }

    private boolean isMetaModelOfRepository(String metaModel) {
        return false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            TableItem item;
            String mName;
            Map input = configuration.getAttribute("Input", new HashMap());
            Map output = configuration.getAttribute("Output", new HashMap());
            Map path = configuration.getAttribute("Path", new HashMap());
            Map type = configuration.getAttribute("ModelType", new HashMap());
            Map modelHandler = configuration.getAttribute("Model Handler", new HashMap());
            Map lib = configuration.getAttribute("Libs", new HashMap());
            this.tableIn.removeAll();
            Iterator i = input.keySet().iterator();
            while (i.hasNext()) {
                mName = (String)i.next();
                item = new TableItem(this.tableIn, 0);
                item.setText(0, mName);
                item.setText(1, (String)input.get(mName));
            }
            this.tableOut.removeAll();
            i = output.keySet().iterator();
            while (i.hasNext()) {
                mName = (String)i.next();
                item = new TableItem(this.tableOut, 0);
                item.setText(0, mName);
                item.setText(1, (String)output.get(mName));
            }
            this.tablePath.removeAll();
            if (type.size() == path.size()) {
                i = path.keySet().iterator();
                while (i.hasNext()) {
                    mName = (String)i.next();
                    item = new TableItem(this.tablePath, 0);
                    item.setText(0, mName);
                    item.setText(1, (String)path.get(mName));
                    item.setText(2, (String)modelHandler.get(mName));
                    item.setText(3, (String)type.get(mName));
                }
            }
            this.tableLib.removeAll();
            i = lib.keySet().iterator();
            while (i.hasNext()) {
                mName = (String)i.next();
                item = new TableItem(this.tableLib, 0);
                item.setText(0, mName);
                item.setText(1, (String)lib.get(mName));
            }
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            this.tableIn.removeAll();
            this.tableOut.removeAll();
            this.tablePath.removeAll();
            this.tableLib.removeAll();
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem ti;
        this.input = new HashMap();
        this.output = new HashMap();
        this.modelPath = new HashMap();
        this.modelType = new HashMap();
        this.modelHandler = new HashMap();
        this.libPath = new HashMap();
        int i = 0;
        while (i < this.tableIn.getItemCount()) {
            ti = this.tableIn.getItem(i);
            this.input.put(ti.getText(0), ti.getText(1));
            ++i;
        }
        i = 0;
        while (i < this.tableOut.getItemCount()) {
            ti = this.tableOut.getItem(i);
            this.output.put(ti.getText(0), ti.getText(1));
            ++i;
        }
        i = 0;
        while (i < this.tablePath.getItemCount()) {
            ti = this.tablePath.getItem(i);
            this.modelPath.put(ti.getText(0), ti.getText(1));
            this.modelType.put(ti.getText(0), ti.getText(3));
            this.modelHandler.put(ti.getText(0), ti.getText(2));
            ++i;
        }
        i = 0;
        while (i < this.tableLib.getItemCount()) {
            ti = this.tableLib.getItem(i);
            this.libPath.put(ti.getText(0), ti.getText(1));
            ++i;
        }
        configuration.setAttribute("Input", this.input);
        configuration.setAttribute("Output", this.output);
        configuration.setAttribute("Path", this.modelPath);
        configuration.setAttribute("ModelType", this.modelType);
        configuration.setAttribute("Model Handler", this.modelHandler);
        configuration.setAttribute("Libs", this.libPath);
    }

    public String getName() {
        return AtlLauncherTools.MODELCHOICETABNAME;
    }

    public boolean canSave() {
        int i;
        if (this.tablePath.getItemCount() == 0) {
            this.setMessage(Messages.getString("ModelChoiceTab.WARNING_GIVEMODELS"));
        } else {
            this.setErrorMessage(Messages.getString("ModelChoiceTab.GIVEPATHMODELS"));
            i = 0;
            while (i < this.tablePath.getItemCount()) {
                if (this.tablePath.getItem(i).getText(1).equals("")) {
                    return false;
                }
                ++i;
            }
        }
        if (this.tableLib.getItemCount() != 0) {
            i = 0;
            while (i < this.tableLib.getItemCount()) {
                if (this.tableLib.getItem(i).getText(1).equals("")) {
                    this.setErrorMessage(Messages.getString("ModelChoiceTab.GIVEPATHLIBS"));
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public Image getImage() {
        return AtlLauncherTools.createImage("icons/atllogo_icon.gif");
    }
}

