/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.ui;

import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.ui.WizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditAttributeDialog
extends Dialog {
    private Button mCheckboxKey = null;
    private Text mTextName = null;
    private Text mTextType = null;
    private Attribute mAttribute = null;
    private String mTitle = "Edit Attribute";

    public EditAttributeDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void okPressed() {
        this.getAttribute().setKey(this.mCheckboxKey.getSelection());
        this.getAttribute().setName(this.mTextName.getText());
        this.getAttribute().setType(this.mTextType.getText());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(result, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(1808));
        Label name = new Label(panel, 0);
        name.setText(WizardMessages.getString("NewEnumWizPageAttr.col.Name"));
        this.mTextName = new Text(panel, 2052);
        this.mTextName.setLayoutData((Object)new GridData(768));
        Label type = new Label(panel, 0);
        type.setText(WizardMessages.getString("NewEnumWizPageAttr.col.Type"));
        this.mTextType = new Text(panel, 2052);
        this.mTextType.setLayoutData((Object)new GridData(768));
        Label key = new Label(panel, 0);
        key.setText(WizardMessages.getString("NewEnumWizPageAttr.col.Key"));
        this.mCheckboxKey = new Button(panel, 32);
        this.initWidgetValues();
        this.hookListeners();
        this.mTextName.forceFocus();
        return result;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    private void initWidgetValues() {
        if (this.getAttribute() == null) {
            throw new IllegalStateException("Attribute not set; cannot initialize");
        }
        this.mCheckboxKey.setSelection(this.getAttribute().isKey());
        this.mTextName.setText(this.getAttribute().getName());
        this.mTextType.setText(this.getAttribute().getType());
    }

    private void hookListeners() {
        this.mTextName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditAttributeDialog.this.validateInput();
            }
        });
        this.mTextType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditAttributeDialog.this.validateInput();
            }
        });
    }

    private void validateInput() {
        boolean hasName = this.mTextName.getText().trim().length() > 0;
        boolean hasType = this.mTextType.getText().trim().length() > 0;
        boolean enabled = hasName && hasType;
        this.getButton(0).setEnabled(enabled);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public Attribute getAttribute() {
        return this.mAttribute;
    }

    public void setAttribute(Attribute attribute) {
        this.mAttribute = attribute;
    }
}

