/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDNamespaceConstraintCategory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDAttributeGroupContentImpl;
import org.eclipse.xsd.impl.XSDAttributeUseImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDRedefinableComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.impl.XSDWildcardImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDAttributeGroupDefinitionImpl
extends XSDRedefinableComponentImpl
implements XSDAttributeGroupDefinition {
    protected static final boolean ATTRIBUTE_GROUP_DEFINITION_REFERENCE_EDEFAULT = false;
    protected XSDAnnotation annotation;
    protected EList<XSDAttributeGroupContent> contents;
    protected EList<XSDAttributeUse> attributeUses;
    protected XSDWildcard attributeWildcardContent;
    protected XSDWildcard attributeWildcard;
    protected XSDAttributeGroupDefinition resolvedAttributeGroupDefinition = this;
    protected XSDWildcard syntheticWildcard;
    protected int analysisState;
    protected XSDWildcardImpl effectiveWildcard;

    public static XSDAttributeGroupDefinition createAttributeGroupDefinition(Node node) {
        if (XSDConstants.nodeType(node) == 6) {
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            xsdAttributeGroupDefinition.setElement((Element)node);
            return xsdAttributeGroupDefinition;
        }
        return null;
    }

    protected XSDAttributeGroupDefinitionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_ATTRIBUTE_GROUP_DEFINITION;
    }

    public Boolean getAttributeGroupDefinitionReference() {
        return this.isAttributeGroupDefinitionReference() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Element createElement() {
        Element newElement = this.createElement(6);
        this.setElement(newElement);
        for (XSDAttributeGroupContent xsdAttributeGroupContent : this.getContents()) {
            if (xsdAttributeGroupContent instanceof XSDAttributeGroupDefinition) {
                XSDAttributeGroupDefinition xsdAttributeGroupDefinition = (XSDAttributeGroupDefinition)xsdAttributeGroupContent;
                Element attributeGroupDefinitionElement = ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).createElement();
                newElement.appendChild(attributeGroupDefinitionElement);
                continue;
            }
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdAttributeGroupContent;
            Element attributeUseElement = ((XSDConcreteComponentImpl)((Object)xsdAttributeUse)).createElement();
            newElement.appendChild(attributeUseElement);
        }
        return newElement;
    }

    @Override
    protected void patch() {
        this.analysisState = 0;
        super.patch();
        XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
        if (theResolvedAttributeGroupDefinition != this && (this.forceResolve || theResolvedAttributeGroupDefinition.getContainer() == null)) {
            XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition = this.resolveAttributeGroupDefinition(theResolvedAttributeGroupDefinition.getTargetNamespace(), theResolvedAttributeGroupDefinition.getName());
            if (this.forceResolve || newResolvedAttributeGroupDefinition.getContainer() != null) {
                this.handleNewResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
            }
        }
    }

    @Override
    protected void traverseToRootForAnalysis() {
        this.analysisState = 0;
        super.traverseToRootForAnalysis();
    }

    @Override
    protected boolean analyze() {
        switch (this.analysisState) {
            case 0: {
                this.analysisState = 1;
                super.analyze();
                this.handleAnalysis();
                if (this.analysisState == 1) {
                    this.analysisState = 2;
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
        }
        this.analysisState = 3;
        return false;
    }

    protected void handleAnalysis() {
        List<XSDAttributeUse> newAttributeUses = XSDAttributeGroupDefinitionImpl.getAttributeUses(this.getContents(), Collections.<XSDAttributeUse>emptyList());
        ArrayList<XSDAttributeUse> remainingAttributeUses = new ArrayList<XSDAttributeUse>((Collection<XSDAttributeUse>)this.getAttributeUses());
        remainingAttributeUses.removeAll(newAttributeUses);
        if (!remainingAttributeUses.isEmpty()) {
            this.getAttributeUses().removeAll(remainingAttributeUses);
        }
        XSDAttributeGroupDefinitionImpl.setListContentAndOrder(this.getAttributeUses(), newAttributeUses);
        XSDWildcard newAttributeWildcard = XSDAttributeGroupDefinitionImpl.getAttributeWildcard(null, this.getAttributeWildcardContent(), this.getContents());
        if (newAttributeWildcard != null && newAttributeWildcard.getContainer() == null) {
            if (this.effectiveWildcard == null) {
                this.effectiveWildcard = (XSDWildcardImpl)this.getXSDFactory().createXSDWildcard();
                this.setSyntheticWildcard(this.effectiveWildcard);
            }
            this.effectiveWildcard.setLike(newAttributeWildcard);
            newAttributeWildcard = this.effectiveWildcard;
        }
        if (newAttributeWildcard != this.getAttributeWildcard()) {
            this.setAttributeWildcard(newAttributeWildcard);
        }
    }

    @Override
    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, new String[]{"id", "name"});
                this.checkComplexContent("namedAttributeGroup", "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement);
            } else {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, new String[]{"id", "ref"});
                this.checkComplexContent("attributeGroupRef", "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement);
            }
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, "id", false);
        }
        if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
            if (this.isAttributeGroupDefinitionReference()) {
                if (theElement == null) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "ref");
                }
            } else {
                this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, "name", true);
                XSDWildcard theAttributeWildcard = this.getAttributeWildcard();
                if (theAttributeWildcard != null && theAttributeWildcard.getNamespaceConstraint().isEmpty() && theAttributeWildcard.getNamespaceConstraintCategory() == XSDNamespaceConstraintCategory.NOT_LITERAL) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute_group.2");
                }
                if (this.isCircular()) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute_group.3");
                }
                XSDAttributeDeclaration idAttribute = null;
                HashSet<String> uris = new HashSet<String>();
                for (XSDAttributeUse xsdAttributeUse : this.getAttributeUses()) {
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    if (!uris.add(xsdAttributeDeclaration.getURI())) {
                        this.getDiagnosticTarget(xsdAttributeUse).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attrGroup.2", xsdAttributeDeclaration.getURI());
                    }
                    if (!XSDConstants.isOrIsDerivedFromID(xsdAttributeDeclaration.getTypeDefinition())) continue;
                    if (idAttribute != null) {
                        this.getDiagnosticTarget(xsdAttributeUse).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attrGroup.3", xsdAttributeDeclaration.getURI(), idAttribute.getURI());
                        continue;
                    }
                    idAttribute = xsdAttributeDeclaration;
                }
            }
        } else if (this.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
            if (theResolvedAttributeGroupDefinition.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedAttributeGroupDefinition_message", theResolvedAttributeGroupDefinition.getURI());
            }
        } else if (theElement == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "name");
        }
    }

    public static List<XSDAttributeUse> getAttributeUses(Collection<XSDAttributeGroupContent> xsdAttributeGroupContents, Collection<XSDAttributeUse> xsdAttributeUses) {
        UniqueEList result = new UniqueEList();
        HashSet<String> localAttributeUses = new HashSet<String>();
        for (XSDAttributeGroupContent xsdAttributeGroupContent : xsdAttributeGroupContents) {
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupContent)).analyze();
            if (xsdAttributeGroupContent instanceof XSDAttributeUse) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdAttributeGroupContent;
                if (xsdAttributeUse.getUse() != XSDAttributeUseCategory.PROHIBITED_LITERAL) {
                    result.add(xsdAttributeUse);
                }
                localAttributeUses.add(xsdAttributeUse.getAttributeDeclaration().getURI());
                continue;
            }
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)xsdAttributeGroupContent).getResolvedAttributeGroupDefinition();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).analyze();
            result.addAll(xsdAttributeGroupDefinition.getAttributeUses());
        }
        for (XSDAttributeUse xsdAttributeUse : xsdAttributeUses) {
            if (localAttributeUses.contains(xsdAttributeUse.getAttributeDeclaration().getURI())) continue;
            result.add(xsdAttributeUse);
        }
        return XSDAttributeUseImpl.sortAttributeUses((Collection<XSDAttributeUse>)result);
    }

    public static XSDWildcard getAttributeWildcard(XSDWildcard baseWildcard, XSDWildcard localWildcard, Collection<XSDAttributeGroupContent> xsdAttributeGroupContents) {
        for (XSDAttributeGroupContent xsdAttributeGroupContent : xsdAttributeGroupContents) {
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupContent)).analyze();
            if (!(xsdAttributeGroupContent instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)xsdAttributeGroupContent).getResolvedAttributeGroupDefinition();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).analyze();
            XSDWildcard attributeGroupWildcard = xsdAttributeGroupDefinition.getAttributeWildcard();
            if (attributeGroupWildcard == null) continue;
            if (localWildcard == null) {
                localWildcard = attributeGroupWildcard;
                continue;
            }
            if ((localWildcard = localWildcard.attributeWildcardIntersection(attributeGroupWildcard)) == null) {
                return null;
            }
            if (!localWildcard.getNamespaceConstraint().isEmpty() || localWildcard.getNamespaceConstraintCategory() != XSDNamespaceConstraintCategory.NOT_LITERAL) continue;
            return localWildcard;
        }
        if (localWildcard == null) {
            localWildcard = baseWildcard;
        } else if (baseWildcard != null) {
            localWildcard = localWildcard.attributeWildcardUnion(baseWildcard);
        }
        return localWildcard;
    }

    @Override
    protected void patchTargetNamespaceAttribute(XSDSchema xsdSchema) {
        if (!this.isAttributeGroupDefinitionReference()) {
            super.patchTargetNamespaceAttribute(xsdSchema);
        }
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition = this;
        if (changedElement.hasAttributeNS(null, "ref")) {
            newResolvedAttributeGroupDefinition = this.resolveAttributeGroupDefinitionURI(XSDConstants.lookupQNameForAttribute(changedElement, "ref"));
        }
        this.handleNewResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
    }

    protected void handleNewResolvedAttributeGroupDefinition(XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition) {
        XSDComponent replacement;
        Map<XSDComponent, XSDComponent> redefinitionMap;
        XSDSchema redefinedSchema;
        EObject parent;
        if (this.eContainer != null && (parent = this.eContainer.eContainer()) instanceof XSDRedefine && (redefinedSchema = ((XSDRedefine)parent).getIncorporatedSchema()) != null && (redefinitionMap = ((XSDSchemaImpl)redefinedSchema).getRedefinitionMap()).containsKey(newResolvedAttributeGroupDefinition) && (replacement = redefinitionMap.get(newResolvedAttributeGroupDefinition)) != null) {
            newResolvedAttributeGroupDefinition = (XSDAttributeGroupDefinition)replacement;
        }
        if (newResolvedAttributeGroupDefinition != this.getResolvedAttributeGroupDefinition()) {
            this.setResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
        }
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
        if (xsdAnnotation != null) {
            newContents.add(xsdAnnotation);
        } else {
            XSDAttributeGroupContent xsdAttributeGroupContent = XSDAttributeGroupContentImpl.createAttributeGroupContent(child);
            if (xsdAttributeGroupContent != null) {
                newContents.add(xsdAttributeGroupContent);
            } else {
                XSDWildcard xsdWildcard = XSDWildcardImpl.createWildcard(child);
                if (xsdWildcard != null) {
                    newContents.add(xsdWildcard);
                }
            }
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        int lastIndex;
        XSDConcreteComponent last;
        this.handleAnnotationReconciliation(XSDPackage.Literals.XSD_ATTRIBUTE_GROUP_DEFINITION__ANNOTATION, newContents, remainingContents);
        XSDWildcard newAttributeWildcard = null;
        if (!newContents.isEmpty() && (last = newContents.get(lastIndex = newContents.size() - 1)) instanceof XSDWildcard) {
            newAttributeWildcard = (XSDWildcard)last;
            if (XSDConstants.nodeType(newAttributeWildcard.getElement()) == 3) {
                newContents.remove(lastIndex);
            } else {
                newAttributeWildcard = null;
            }
        }
        if (newAttributeWildcard != this.getAttributeWildcardContent()) {
            remainingContents.remove(this.getAttributeWildcardContent());
            this.setAttributeWildcardContent(newAttributeWildcard);
        }
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        if (!newContents.isEmpty()) {
            Iterator<XSDConcreteComponent> i = newContents.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof XSDAttributeGroupContent) continue;
                i.remove();
            }
            List<XSDConcreteComponent> list = newContents;
            XSDAttributeGroupDefinitionImpl.setListContentAndOrder(this.getContents(), list);
        }
    }

    @Override
    protected void changeReference(EReference eReference) {
        XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition;
        if (this.isReconciling) {
            return;
        }
        super.changeReference(eReference);
        Element theElement = this.getElement();
        if (theElement != null && (eReference == null || eReference == XSDPackage.Literals.XSD_ATTRIBUTE_GROUP_DEFINITION__RESOLVED_ATTRIBUTE_GROUP_DEFINITION) && (theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition()) != this) {
            this.niceSetAttributeURIValue(theElement, "ref", theResolvedAttributeGroupDefinition.getURI());
        }
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_GROUP_DEFINITION__CONTENTS) {
            this.traverseToRootForPatching();
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_ATTRIBUTE_GROUP_DEFINITION__CONTENTS) {
            this.traverseToRootForPatching();
        }
    }

    @Override
    public boolean isAttributeGroupDefinitionReference() {
        return this != this.getResolvedAttributeGroupDefinition();
    }

    @Override
    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<XSDAttributeGroupContent> getContents() {
        if (this.contents == null) {
            this.contents = new EObjectContainmentEList(XSDAttributeGroupContent.class, (InternalEObject)this, 14);
        }
        return this.contents;
    }

    @Override
    public EList<XSDAttributeUse> getAttributeUses() {
        if (this.attributeUses == null) {
            this.attributeUses = new EObjectEList(XSDAttributeUse.class, (InternalEObject)this, 15);
        }
        return this.attributeUses;
    }

    @Override
    public XSDWildcard getAttributeWildcardContent() {
        return this.attributeWildcardContent;
    }

    @Override
    public void setAttributeWildcardContent(XSDWildcard newAttributeWildcardContent) {
        if (newAttributeWildcardContent != this.attributeWildcardContent) {
            NotificationChain msgs = null;
            if (this.attributeWildcardContent != null) {
                msgs = ((InternalEObject)this.attributeWildcardContent).eInverseRemove((InternalEObject)this, -17, null, msgs);
            }
            if (newAttributeWildcardContent != null) {
                msgs = ((InternalEObject)newAttributeWildcardContent).eInverseAdd((InternalEObject)this, -17, null, msgs);
            }
            if ((msgs = this.basicSetAttributeWildcardContent(newAttributeWildcardContent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newAttributeWildcardContent, (Object)newAttributeWildcardContent));
        }
    }

    public NotificationChain basicSetAttributeWildcardContent(XSDWildcard newAttributeWildcardContent, NotificationChain msgs) {
        XSDWildcard oldAttributeWildcardContent = this.attributeWildcardContent;
        this.attributeWildcardContent = newAttributeWildcardContent;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldAttributeWildcardContent, (Object)newAttributeWildcardContent);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public XSDWildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    @Override
    public void setAttributeWildcard(XSDWildcard newAttributeWildcard) {
        XSDWildcard oldAttributeWildcard = this.attributeWildcard;
        this.attributeWildcard = newAttributeWildcard;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldAttributeWildcard, (Object)this.attributeWildcard));
        }
    }

    @Override
    public XSDAttributeGroupDefinition getResolvedAttributeGroupDefinition() {
        return this.resolvedAttributeGroupDefinition;
    }

    @Override
    public void setResolvedAttributeGroupDefinition(XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition) {
        XSDAttributeGroupDefinition oldResolvedAttributeGroupDefinition = this.resolvedAttributeGroupDefinition;
        this.resolvedAttributeGroupDefinition = newResolvedAttributeGroupDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldResolvedAttributeGroupDefinition, (Object)this.resolvedAttributeGroupDefinition));
        }
    }

    @Override
    public XSDWildcard getSyntheticWildcard() {
        return this.syntheticWildcard;
    }

    public NotificationChain basicSetSyntheticWildcard(XSDWildcard newSyntheticWildcard, NotificationChain msgs) {
        XSDWildcard oldSyntheticWildcard = this.syntheticWildcard;
        this.syntheticWildcard = newSyntheticWildcard;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldSyntheticWildcard, (Object)newSyntheticWildcard);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSyntheticWildcard(XSDWildcard newSyntheticWildcard) {
        if (newSyntheticWildcard != this.syntheticWildcard) {
            NotificationChain msgs = null;
            if (this.syntheticWildcard != null) {
                msgs = ((InternalEObject)this.syntheticWildcard).eInverseRemove((InternalEObject)this, -20, null, msgs);
            }
            if (newSyntheticWildcard != null) {
                msgs = ((InternalEObject)newSyntheticWildcard).eInverseAdd((InternalEObject)this, -20, null, msgs);
            }
            if ((msgs = this.basicSetSyntheticWildcard(newSyntheticWildcard, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)newSyntheticWildcard, (Object)newSyntheticWildcard));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return this.basicSetAnnotation(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return this.basicSetAttributeWildcardContent(null, msgs);
            }
            case 19: {
                return this.basicSetSyntheticWildcard(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.isAttributeGroupDefinitionReference();
            }
            case 13: {
                return this.getAnnotation();
            }
            case 14: {
                return this.getContents();
            }
            case 15: {
                return this.getAttributeUses();
            }
            case 16: {
                return this.getAttributeWildcardContent();
            }
            case 17: {
                return this.getAttributeWildcard();
            }
            case 18: {
                return this.getResolvedAttributeGroupDefinition();
            }
            case 19: {
                return this.getSyntheticWildcard();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 14: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getAttributeUses().clear();
                this.getAttributeUses().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setAttributeWildcardContent((XSDWildcard)newValue);
                return;
            }
            case 17: {
                this.setAttributeWildcard((XSDWildcard)newValue);
                return;
            }
            case 18: {
                this.setResolvedAttributeGroupDefinition((XSDAttributeGroupDefinition)newValue);
                return;
            }
            case 19: {
                this.setSyntheticWildcard((XSDWildcard)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setAnnotation(null);
                return;
            }
            case 14: {
                this.getContents().clear();
                return;
            }
            case 15: {
                this.getAttributeUses().clear();
                return;
            }
            case 16: {
                this.setAttributeWildcardContent(null);
                return;
            }
            case 17: {
                this.setAttributeWildcard(null);
                return;
            }
            case 18: {
                this.setResolvedAttributeGroupDefinition(null);
                return;
            }
            case 19: {
                this.setSyntheticWildcard(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return this.isAttributeGroupDefinitionReference();
            }
            case 13: {
                return this.annotation != null;
            }
            case 14: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 15: {
                return this.attributeUses != null && !this.attributeUses.isEmpty();
            }
            case 16: {
                return this.attributeWildcardContent != null;
            }
            case 17: {
                return this.attributeWildcard != null;
            }
            case 18: {
                return this.resolvedAttributeGroupDefinition != null;
            }
            case 19: {
                return this.syntheticWildcard != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String getQName() {
        XSDAttributeGroupDefinition resolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
        if (resolvedAttributeGroupDefinition == this) {
            return super.getQName();
        }
        return resolvedAttributeGroupDefinition.getQName(this);
    }

    @Override
    public boolean isNamedComponentReference() {
        return this.isAttributeGroupDefinitionReference();
    }

    @Override
    public XSDNamedComponent getResolvedNamedComponent() {
        return this.getResolvedAttributeGroupDefinition();
    }

    @Override
    public boolean isCircular() {
        return this.analysisState == 3;
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeGroupDefinitionImpl clonedAttributeGroupDefinition = (XSDAttributeGroupDefinitionImpl)this.getXSDFactory().createXSDAttributeGroupDefinition();
        clonedAttributeGroupDefinition.isReconciling = true;
        if (this.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
            clonedAttributeGroupDefinition.setResolvedAttributeGroupDefinition(this.createUnresolvedAttributeGroupDefinition(theResolvedAttributeGroupDefinition.getTargetNamespace(), theResolvedAttributeGroupDefinition.getName()));
        } else if (this.getName() != null) {
            clonedAttributeGroupDefinition.setName(this.getName());
        }
        if (deep) {
            if (this.getAnnotation() != null) {
                clonedAttributeGroupDefinition.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(true, shareDOM));
            }
            if (!this.getContents().isEmpty()) {
                clonedAttributeGroupDefinition.getContents().addAll(XSDAttributeGroupDefinitionImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
            }
            if (this.getAttributeWildcardContent() != null) {
                clonedAttributeGroupDefinition.setAttributeWildcardContent((XSDWildcard)this.getAttributeWildcardContent().cloneConcreteComponent(true, shareDOM));
            }
        }
        if (shareDOM && this.getElement() != null) {
            clonedAttributeGroupDefinition.setElement(this.getElement());
        }
        clonedAttributeGroupDefinition.isReconciling = shareDOM;
        return clonedAttributeGroupDefinition;
    }
}

